/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.hive.druid.org.apache.druid.java.util.common.MapUtils;
import org.apache.hive.druid.org.apache.druid.segment.loading.DataSegmentArchiver;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;

public class OmniDataSegmentArchiver
implements DataSegmentArchiver {
    private final Map<String, DataSegmentArchiver> archivers;

    @Inject
    public OmniDataSegmentArchiver(Map<String, DataSegmentArchiver> archivers) {
        this.archivers = archivers;
    }

    @Override
    public DataSegment archive(DataSegment segment) throws SegmentLoadingException {
        return this.getArchiver(segment).archive(segment);
    }

    @Override
    public DataSegment restore(DataSegment segment) throws SegmentLoadingException {
        return this.getArchiver(segment).restore(segment);
    }

    private DataSegmentArchiver getArchiver(DataSegment segment) throws SegmentLoadingException {
        String type = MapUtils.getString(segment.getLoadSpec(), "type");
        DataSegmentArchiver archiver = this.archivers.get(type);
        if (archiver == null) {
            throw new SegmentLoadingException("Unknown loader type[%s].  Known types are %s", type, this.archivers.keySet());
        }
        return archiver;
    }
}

