/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.java.util.common.IOE;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.segment.SegmentUtils;
import org.apache.hive.druid.org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalDataSegmentPusherConfig;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.utils.CompressionUtils;

public class LocalDataSegmentPusher
implements DataSegmentPusher {
    private static final Logger log = new Logger(LocalDataSegmentPusher.class);
    private static final String INDEX_FILENAME = "index.zip";
    private final LocalDataSegmentPusherConfig config;

    @Inject
    public LocalDataSegmentPusher(LocalDataSegmentPusherConfig config) {
        this.config = config;
    }

    @Override
    public String getPathForHadoop() {
        return this.config.getStorageDirectory().getAbsoluteFile().toURI().toString();
    }

    @Override
    @Deprecated
    public String getPathForHadoop(String dataSource) {
        return this.getPathForHadoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSegment push(File dataSegmentFile, DataSegment segment, boolean useUniquePath) throws IOException {
        File baseStorageDir = this.config.getStorageDirectory();
        File outDir = new File(baseStorageDir, this.getStorageDir(segment, useUniquePath));
        log.debug("Copying segment[%s] to local filesystem at location[%s]", segment.getId(), outDir.toString());
        if (dataSegmentFile.equals(outDir)) {
            long size = 0L;
            for (File file : dataSegmentFile.listFiles()) {
                size += file.length();
            }
            return segment.withLoadSpec(this.makeLoadSpec(outDir.toURI())).withSize(size).withBinaryVersion(SegmentUtils.getVersionFromDir(dataSegmentFile));
        }
        File tmpOutDir = new File(baseStorageDir, this.makeIntermediateDir());
        log.debug("Creating intermediate directory[%s] for segment[%s].", tmpOutDir.toString(), segment.getId());
        FileUtils.forceMkdir((File)tmpOutDir);
        try {
            File tmpIndexFile = new File(tmpOutDir, INDEX_FILENAME);
            long size = this.compressSegment(dataSegmentFile, tmpIndexFile);
            DataSegment dataSegment = segment.withLoadSpec(this.makeLoadSpec(new File(outDir, INDEX_FILENAME).toURI())).withSize(size).withBinaryVersion(SegmentUtils.getVersionFromDir(dataSegmentFile));
            FileUtils.forceMkdir((File)outDir);
            File indexFileTarget = new File(outDir, tmpIndexFile.getName());
            if (!tmpIndexFile.renameTo(indexFileTarget)) {
                throw new IOE("Failed to rename [%s] to [%s]", tmpIndexFile, indexFileTarget);
            }
            DataSegment dataSegment2 = dataSegment;
            return dataSegment2;
        }
        finally {
            org.apache.hive.druid.org.apache.druid.java.util.common.FileUtils.deleteDirectory(tmpOutDir);
        }
    }

    @Override
    public Map<String, Object> makeLoadSpec(URI finalIndexZipFilePath) {
        return ImmutableMap.of("type", "local", "path", finalIndexZipFilePath.getPath());
    }

    private String makeIntermediateDir() {
        return "intermediate_pushes/" + UUID.randomUUID();
    }

    private long compressSegment(File dataSegmentFile, File dest) throws IOException {
        log.debug("Compressing files from[%s] to [%s]", dataSegmentFile, dest);
        return CompressionUtils.zip(dataSegmentFile, dest, true);
    }
}

