/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.data;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.org.apache.druid.segment.data.VSizeLongSerde;
import org.apache.hive.druid.org.apache.druid.segment.writeout.WriteOutBytes;

public class TableLongEncodingWriter
implements CompressionFactory.LongEncodingWriter {
    private final Long2IntMap table;
    private final LongList valueAddedInOrder;
    private final int bitsPerValue;
    private VSizeLongSerde.LongSerializer serializer;

    public TableLongEncodingWriter(Long2IntMap table, LongList valueAddedInOrder) {
        if (table.size() > 256) {
            throw new IAE("Invalid table size[%s]", table.size());
        }
        this.table = table;
        this.valueAddedInOrder = valueAddedInOrder;
        this.bitsPerValue = VSizeLongSerde.getBitsForMax(table.size());
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.serializer = VSizeLongSerde.getSerializer(this.bitsPerValue, buffer, buffer.position());
    }

    @Override
    public void setOutputStream(WriteOutBytes output) {
        this.serializer = VSizeLongSerde.getSerializer(this.bitsPerValue, output);
    }

    @Override
    public void write(long value) throws IOException {
        this.serializer.write(this.table.get(value));
    }

    @Override
    public void flush() throws IOException {
        if (this.serializer != null) {
            this.serializer.close();
        }
    }

    @Override
    public void putMeta(ByteBuffer metaOut, CompressionStrategy strategy) {
        metaOut.put(CompressionFactory.setEncodingFlag(strategy.getId()));
        metaOut.put(CompressionFactory.LongEncodingFormat.TABLE.getId());
        metaOut.put((byte)1);
        metaOut.putInt(this.table.size());
        for (int i = 0; i < this.valueAddedInOrder.size(); ++i) {
            metaOut.putLong(this.valueAddedInOrder.getLong(i));
        }
    }

    @Override
    public int metaSize() {
        return 7 + this.table.size() * 8;
    }

    @Override
    public int getBlockSize(int bytesPerBlock) {
        return VSizeLongSerde.getNumValuesPerBlock(this.bitsPerValue, bytesPerBlock);
    }

    @Override
    public int getNumBytes(int values) {
        return VSizeLongSerde.getSerializedSize(this.bitsPerValue, values);
    }
}

