/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.spatial.ImmutableRTree;
import org.apache.hive.druid.org.apache.druid.segment.data.ObjectStrategy;
import org.apache.hive.druid.org.apache.druid.segment.writeout.WriteOutBytes;

public class ImmutableRTreeObjectStrategy
implements ObjectStrategy<ImmutableRTree> {
    private static Ordering<ImmutableRTree> comparator = new Ordering<ImmutableRTree>(){

        @Override
        public int compare(ImmutableRTree tree, ImmutableRTree tree1) {
            if (tree.size() == 0 && tree1.size() == 0) {
                return 0;
            }
            if (tree.size() == 0) {
                return -1;
            }
            if (tree1.size() == 0) {
                return 1;
            }
            return tree.compareTo(tree1);
        }
    }.nullsFirst();
    private final BitmapFactory bitmapFactory;

    public ImmutableRTreeObjectStrategy(BitmapFactory bitmapFactory) {
        this.bitmapFactory = bitmapFactory;
    }

    @Override
    public Class<ImmutableRTree> getClazz() {
        return ImmutableRTree.class;
    }

    @Override
    public ImmutableRTree fromByteBuffer(ByteBuffer buffer, int numBytes) {
        buffer.limit(buffer.position() + numBytes);
        return new ImmutableRTree(buffer, this.bitmapFactory);
    }

    @Override
    public byte[] toBytes(ImmutableRTree val) {
        return val.toBytes();
    }

    @Override
    public void writeTo(ImmutableRTree val, WriteOutBytes out) throws IOException {
        val.writeTo(out);
    }

    @Override
    public int compare(ImmutableRTree o1, ImmutableRTree o2) {
        return comparator.compare(o1, o2);
    }
}

