/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.org.apache.druid.segment.data.ObjectStrategy;
import org.apache.hive.druid.org.apache.druid.segment.serde.Serializer;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.hive.druid.org.apache.druid.segment.writeout.WriteOutBytes;

public class ByteBufferWriter<T>
implements Serializer {
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final ObjectStrategy<T> strategy;
    @Nullable
    private WriteOutBytes headerOut = null;
    @Nullable
    private WriteOutBytes valueOut = null;

    public ByteBufferWriter(SegmentWriteOutMedium segmentWriteOutMedium, ObjectStrategy<T> strategy) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.strategy = strategy;
    }

    public void open() throws IOException {
        this.headerOut = this.segmentWriteOutMedium.makeWriteOutBytes();
        this.valueOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    public void write(T objectToWrite) throws IOException {
        long sizeBefore = this.valueOut.size();
        this.strategy.writeTo(objectToWrite, this.valueOut);
        this.headerOut.writeInt(Ints.checkedCast(this.valueOut.size() - sizeBefore));
    }

    @Override
    public long getSerializedSize() throws IOException {
        return this.headerOut.size() + this.valueOut.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        long numBytesWritten = this.headerOut.size() + this.valueOut.size();
        Preconditions.checkState(numBytesWritten < Integer.MAX_VALUE, "Wrote[%s] bytes, which is too many.", numBytesWritten);
        this.headerOut.writeTo(channel);
        this.valueOut.writeTo(channel);
    }
}

