/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.data;

import it.unimi.dsi.fastutil.ints.IntArrays;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.data.IndexedInts;

public final class ArrayBasedIndexedInts
implements IndexedInts {
    static final IndexedInts EMPTY = new ArrayBasedIndexedInts();
    private int[] expansion;
    private int size;

    public ArrayBasedIndexedInts() {
        this.expansion = IntArrays.EMPTY_ARRAY;
        this.size = 0;
    }

    public ArrayBasedIndexedInts(int[] expansion) {
        this.expansion = expansion;
        this.size = expansion.length;
    }

    public void ensureSize(int size) {
        if (this.expansion.length < size) {
            this.expansion = new int[size];
        }
    }

    public void setSize(int size) {
        if (size < 0 || size > this.expansion.length) {
            throw new IAE("Size[%d] > expansion.length[%d] or < 0", size, this.expansion.length);
        }
        this.size = size;
    }

    public void setValues(int[] values, int size) {
        if (size < 0 || size > values.length) {
            throw new IAE("Size[%d] should be between 0 and %d", size, values.length);
        }
        this.ensureSize(size);
        System.arraycopy(values, 0, this.expansion, 0, size);
        this.size = size;
    }

    public void setValue(int index, int value) {
        this.expansion[index] = value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IAE("index[%d] >= size[%d] or < 0", index, this.size);
        }
        return this.expansion[index];
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }
}

