/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.column;

import java.io.IOException;
import java.util.BitSet;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.hive.druid.org.apache.druid.segment.IdLookup;
import org.apache.hive.druid.org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.hive.druid.org.apache.druid.segment.data.CachingIndexed;
import org.apache.hive.druid.org.apache.druid.segment.data.ColumnarInts;
import org.apache.hive.druid.org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.hive.druid.org.apache.druid.segment.data.IndexedInts;
import org.apache.hive.druid.org.apache.druid.segment.data.ReadableOffset;
import org.apache.hive.druid.org.apache.druid.segment.data.SingleIndexedInt;
import org.apache.hive.druid.org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.hive.druid.org.apache.druid.segment.historical.HistoricalDimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.historical.SingleValueHistoricalDimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.hive.druid.org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;

public class StringDictionaryEncodedColumn
implements DictionaryEncodedColumn<String> {
    @Nullable
    private final ColumnarInts column;
    @Nullable
    private final ColumnarMultiInts multiValueColumn;
    private final CachingIndexed<String> cachedLookups;

    public StringDictionaryEncodedColumn(@Nullable ColumnarInts singleValueColumn, @Nullable ColumnarMultiInts multiValueColumn, CachingIndexed<String> cachedLookups) {
        this.column = singleValueColumn;
        this.multiValueColumn = multiValueColumn;
        this.cachedLookups = cachedLookups;
    }

    @Override
    public int length() {
        return this.hasMultipleValues() ? this.multiValueColumn.size() : this.column.size();
    }

    @Override
    public boolean hasMultipleValues() {
        return this.column == null;
    }

    @Override
    public int getSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    public IndexedInts getMultiValueRow(int rowNum) {
        return this.multiValueColumn.get(rowNum);
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        return this.cachedLookups.get(id);
    }

    @Override
    public int lookupId(String name) {
        return this.cachedLookups.indexOf(name);
    }

    @Override
    public int getCardinality() {
        return this.cachedLookups.size();
    }

    @Override
    public HistoricalDimensionSelector makeDimensionSelector(final ReadableOffset offset, final @Nullable ExtractionFn extractionFn) {
        if (this.hasMultipleValues()) {
            class MultiValueDimensionSelector
            extends 1QueryableDimensionSelector {
                MultiValueDimensionSelector() {
                    abstract class QueryableDimensionSelector
                    extends AbstractDimensionSelector
                    implements HistoricalDimensionSelector,
                    IdLookup {
                        final /* synthetic */ ExtractionFn val$extractionFn;

                        QueryableDimensionSelector() {
                            this.val$extractionFn = extractionFn;
                        }

                        @Override
                        public int getValueCardinality() {
                            return StringDictionaryEncodedColumn.this.getCardinality();
                        }

                        @Override
                        public String lookupName(int id) {
                            String value = StringDictionaryEncodedColumn.this.lookupName(id);
                            return this.val$extractionFn == null ? value : this.val$extractionFn.apply(value);
                        }

                        @Override
                        public boolean nameLookupPossibleInAdvance() {
                            return true;
                        }

                        @Override
                        @Nullable
                        public IdLookup idLookup() {
                            return this.val$extractionFn == null ? this : null;
                        }

                        @Override
                        public int lookupId(String name) {
                            if (this.val$extractionFn != null) {
                                throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                            }
                            return StringDictionaryEncodedColumn.this.lookupId(name);
                        }
                    }
                    super(StringDictionaryEncodedColumn.this, extractionFn2);
                }

                @Override
                public IndexedInts getRow() {
                    return StringDictionaryEncodedColumn.this.multiValueColumn.get(offset.getOffset());
                }

                @Override
                public IndexedInts getRow(int offset2) {
                    return StringDictionaryEncodedColumn.this.multiValueColumn.get(offset2);
                }

                @Override
                public ValueMatcher makeValueMatcher(@Nullable String value) {
                    return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
                }

                @Override
                public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                    return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
                }

                @Override
                @Nullable
                public Object getObject() {
                    return this.defaultGetObject();
                }

                @Override
                public Class classOfObject() {
                    return Object.class;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("multiValueColumn", StringDictionaryEncodedColumn.this.multiValueColumn);
                    inspector.visit("offset", offset);
                    inspector.visit("extractionFn", extractionFn);
                }
            }
            return new MultiValueDimensionSelector();
        }
        class SingleValueQueryableDimensionSelector
        extends 1QueryableDimensionSelector
        implements SingleValueHistoricalDimensionSelector {
            private final SingleIndexedInt row;

            SingleValueQueryableDimensionSelector() {
                super(StringDictionaryEncodedColumn.this, extractionFn2);
                this.row = new SingleIndexedInt();
            }

            @Override
            public IndexedInts getRow() {
                this.row.setValue(this.getRowValue());
                return this.row;
            }

            public int getRowValue() {
                return StringDictionaryEncodedColumn.this.column.get(offset.getOffset());
            }

            @Override
            public IndexedInts getRow(int offset2) {
                this.row.setValue(this.getRowValue(offset2));
                return this.row;
            }

            @Override
            public int getRowValue(int offset2) {
                return StringDictionaryEncodedColumn.this.column.get(offset2);
            }

            @Override
            public ValueMatcher makeValueMatcher(@Nullable String value) {
                if (extractionFn == null) {
                    final int valueId = this.lookupId(value);
                    if (valueId >= 0) {
                        return new ValueMatcher(){

                            @Override
                            public boolean matches() {
                                return this.getRowValue() == valueId;
                            }

                            @Override
                            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                                inspector.visit("column", StringDictionaryEncodedColumn.this);
                            }
                        };
                    }
                    return BooleanValueMatcher.of(false);
                }
                return this.makeValueMatcher(Predicates.equalTo(value));
            }

            @Override
            public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
                final BitSet checkedIds = new BitSet(StringDictionaryEncodedColumn.this.getCardinality());
                final BitSet matchingIds = new BitSet(StringDictionaryEncodedColumn.this.getCardinality());
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        int id = this.getRowValue();
                        if (checkedIds.get(id)) {
                            return matchingIds.get(id);
                        }
                        boolean matches = predicate.apply(this.lookupName(id));
                        checkedIds.set(id);
                        if (matches) {
                            matchingIds.set(id);
                        }
                        return matches;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("column", StringDictionaryEncodedColumn.this);
                    }
                };
            }

            @Override
            public Object getObject() {
                return this.lookupName(this.getRowValue());
            }

            @Override
            public Class classOfObject() {
                return String.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", StringDictionaryEncodedColumn.this.column);
                inspector.visit("offset", offset);
                inspector.visit("extractionFn", extractionFn);
            }
        }
        return new SingleValueQueryableDimensionSelector();
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(final ReadableVectorOffset offset) {
        class QueryableSingleValueDimensionVectorSelector
        implements SingleValueDimensionVectorSelector,
        IdLookup {
            private final int[] vector;
            private int id;

            QueryableSingleValueDimensionVectorSelector() {
                this.vector = new int[offset.getMaxVectorSize()];
                this.id = -1;
            }

            @Override
            public int[] getRowVector() {
                if (this.id == offset.getId()) {
                    return this.vector;
                }
                if (offset.isContiguous()) {
                    StringDictionaryEncodedColumn.this.column.get(this.vector, offset.getStartOffset(), offset.getCurrentVectorSize());
                } else {
                    StringDictionaryEncodedColumn.this.column.get(this.vector, offset.getOffsets(), offset.getCurrentVectorSize());
                }
                this.id = offset.getId();
                return this.vector;
            }

            @Override
            public int getValueCardinality() {
                return StringDictionaryEncodedColumn.this.getCardinality();
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return StringDictionaryEncodedColumn.this.lookupName(id);
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return true;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return this;
            }

            @Override
            public int lookupId(@Nullable String name) {
                return StringDictionaryEncodedColumn.this.lookupId(name);
            }

            @Override
            public int getCurrentVectorSize() {
                return offset.getCurrentVectorSize();
            }

            @Override
            public int getMaxVectorSize() {
                return offset.getMaxVectorSize();
            }
        }
        return new QueryableSingleValueDimensionVectorSelector();
    }

    @Override
    public MultiValueDimensionVectorSelector makeMultiValueDimensionVectorSelector(final ReadableVectorOffset offset) {
        class QueryableMultiValueDimensionVectorSelector
        implements MultiValueDimensionVectorSelector,
        IdLookup {
            private final IndexedInts[] vector;
            private int id;

            QueryableMultiValueDimensionVectorSelector() {
                this.vector = new IndexedInts[offset.getMaxVectorSize()];
                this.id = -1;
            }

            @Override
            public IndexedInts[] getRowVector() {
                if (this.id == offset.getId()) {
                    return this.vector;
                }
                if (offset.isContiguous()) {
                    int currentOffset = offset.getStartOffset();
                    int numRows = offset.getCurrentVectorSize();
                    for (int i = 0; i < numRows; ++i) {
                        this.vector[i] = StringDictionaryEncodedColumn.this.multiValueColumn.getUnshared(i + currentOffset);
                    }
                } else {
                    int[] offsets = offset.getOffsets();
                    int numRows = offset.getCurrentVectorSize();
                    for (int i = 0; i < numRows; ++i) {
                        this.vector[i] = StringDictionaryEncodedColumn.this.multiValueColumn.getUnshared(offsets[i]);
                    }
                }
                this.id = offset.getId();
                return this.vector;
            }

            @Override
            public int getValueCardinality() {
                return StringDictionaryEncodedColumn.this.getCardinality();
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return StringDictionaryEncodedColumn.this.lookupName(id);
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return true;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return this;
            }

            @Override
            public int lookupId(@Nullable String name) {
                return StringDictionaryEncodedColumn.this.lookupId(name);
            }

            @Override
            public int getCurrentVectorSize() {
                return offset.getCurrentVectorSize();
            }

            @Override
            public int getMaxVectorSize() {
                return offset.getMaxVectorSize();
            }
        }
        return new QueryableMultiValueDimensionVectorSelector();
    }

    @Override
    public void close() throws IOException {
        CloseQuietly.close(this.cachedLookups);
        if (this.column != null) {
            this.column.close();
        }
        if (this.multiValueColumn != null) {
            this.multiValueColumn.close();
        }
    }
}

