/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.column;

import org.apache.hive.druid.org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.column.DoublesColumn;
import org.apache.hive.druid.org.apache.druid.segment.data.ColumnarDoubles;
import org.apache.hive.druid.org.apache.druid.segment.data.ReadableOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorValueSelector;

class DoublesColumnWithNulls
extends DoublesColumn {
    private final ImmutableBitmap nullValueBitmap;

    DoublesColumnWithNulls(ColumnarDoubles columnarDoubles, ImmutableBitmap nullValueBitmap) {
        super(columnarDoubles);
        this.nullValueBitmap = nullValueBitmap;
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(ReadableOffset offset) {
        return this.column.makeColumnValueSelector(offset, this.nullValueBitmap);
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(ReadableVectorOffset offset) {
        return this.column.makeVectorValueSelector(offset, this.nullValueBitmap);
    }

    @Override
    public long getLongSingleValueRow(int rowNum) {
        assert (!this.nullValueBitmap.get(rowNum));
        return super.getLongSingleValueRow(rowNum);
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        super.inspectRuntimeShape(inspector);
        inspector.visit("nullValueBitmap", this.nullValueBitmap);
    }
}

