/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.google.common.hash.HashFunction;
import org.apache.hive.druid.com.google.common.hash.Hasher;
import org.apache.hive.druid.com.google.common.hash.Hashing;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.org.apache.druid.java.util.common.IOE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;

public class SegmentUtils {
    private static final HashFunction HASH_FUNCTION = Hashing.sha256();

    public static String hashIds(List<DataSegment> segments) {
        Collections.sort(segments);
        Hasher hasher = HASH_FUNCTION.newHasher();
        segments.forEach(segment -> hasher.putString(segment.getId().toString(), StandardCharsets.UTF_8));
        return StringUtils.fromUtf8(hasher.hash().asBytes());
    }

    public static int getVersionFromDir(File inDir) throws IOException {
        File versionFile = new File(inDir, "version.bin");
        if (versionFile.exists()) {
            return Ints.fromByteArray(Files.toByteArray(versionFile));
        }
        File indexFile = new File(inDir, "index.drd");
        if (indexFile.exists()) {
            int version;
            try (FileInputStream in = new FileInputStream(indexFile);){
                version = ((InputStream)in).read();
            }
            return version;
        }
        throw new IOE("Invalid segment dir [%s]. Can't find either of version.bin or index.drd.", inDir);
    }

    public static String commaSeparateIdentifiers(Collection<DataSegment> segments) {
        return segments.stream().map(segment -> segment.getId().toString()).collect(Collectors.joining(", "));
    }

    private SegmentUtils() {
    }
}

