/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.Closer;
import org.apache.hive.druid.org.apache.druid.query.BaseQuery;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.BitmapOffset;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorBitmapIndexSelector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.Cursor;
import org.apache.hive.druid.org.apache.druid.segment.FilteredOffset;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.hive.druid.org.apache.druid.segment.SimpleDescendingOffset;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumns;
import org.apache.hive.druid.org.apache.druid.segment.column.BaseColumn;
import org.apache.hive.druid.org.apache.druid.segment.column.NumericColumn;
import org.apache.hive.druid.org.apache.druid.segment.data.Offset;
import org.apache.hive.druid.org.apache.druid.segment.data.ReadableOffset;
import org.apache.hive.druid.org.apache.druid.segment.historical.HistoricalCursor;
import org.apache.hive.druid.org.apache.druid.segment.vector.BitmapVectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.FilteredVectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.QueryableIndexVectorColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorCursor;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorOffset;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class QueryableIndexCursorSequenceBuilder {
    private final QueryableIndex index;
    private final Interval interval;
    private final VirtualColumns virtualColumns;
    @Nullable
    private final ImmutableBitmap filterBitmap;
    private final long minDataTimestamp;
    private final long maxDataTimestamp;
    private final boolean descending;
    @Nullable
    private final Filter postFilter;
    @Nullable
    private final ColumnSelectorBitmapIndexSelector bitmapIndexSelector;

    public QueryableIndexCursorSequenceBuilder(QueryableIndex index, Interval interval, VirtualColumns virtualColumns, @Nullable ImmutableBitmap filterBitmap, long minDataTimestamp, long maxDataTimestamp, boolean descending, @Nullable Filter postFilter, @Nullable ColumnSelectorBitmapIndexSelector bitmapIndexSelector) {
        this.index = index;
        this.interval = interval;
        this.virtualColumns = virtualColumns;
        this.filterBitmap = filterBitmap;
        this.minDataTimestamp = minDataTimestamp;
        this.maxDataTimestamp = maxDataTimestamp;
        this.descending = descending;
        this.postFilter = postFilter;
        this.bitmapIndexSelector = bitmapIndexSelector;
    }

    public Sequence<Cursor> build(final Granularity gran) {
        final Offset baseOffset = this.filterBitmap == null ? (this.descending ? new SimpleDescendingOffset(this.index.getNumRows()) : new SimpleAscendingOffset(this.index.getNumRows())) : BitmapOffset.of(this.filterBitmap, this.descending, this.index.getNumRows());
        final HashMap columnCache = new HashMap();
        final NumericColumn timestamps = (NumericColumn)this.index.getColumnHolder("__time").getColumn();
        final Closer closer = Closer.create();
        closer.register(timestamps);
        Iterable<Interval> iterable = gran.getIterable(this.interval);
        if (this.descending) {
            iterable = Lists.reverse(ImmutableList.copyOf(iterable));
        }
        return Sequences.withBaggage(Sequences.map(Sequences.simple(iterable), new Function<Interval, Cursor>(){

            @Override
            public Cursor apply(Interval inputInterval) {
                long timeStart = Math.max(QueryableIndexCursorSequenceBuilder.this.interval.getStartMillis(), inputInterval.getStartMillis());
                long timeEnd = Math.min(QueryableIndexCursorSequenceBuilder.this.interval.getEndMillis(), gran.increment(inputInterval.getStart()).getMillis());
                if (QueryableIndexCursorSequenceBuilder.this.descending) {
                    while (baseOffset.withinBounds() && timestamps.getLongSingleValueRow(baseOffset.getOffset()) >= timeEnd) {
                        baseOffset.increment();
                    }
                } else {
                    while (baseOffset.withinBounds() && timestamps.getLongSingleValueRow(baseOffset.getOffset()) < timeStart) {
                        baseOffset.increment();
                    }
                }
                TimestampCheckingOffset offset = QueryableIndexCursorSequenceBuilder.this.descending ? new DescendingTimestampCheckingOffset(baseOffset, timestamps, timeStart, QueryableIndexCursorSequenceBuilder.this.minDataTimestamp >= timeStart) : new AscendingTimestampCheckingOffset(baseOffset, timestamps, timeEnd, QueryableIndexCursorSequenceBuilder.this.maxDataTimestamp < timeEnd);
                Offset baseCursorOffset = ((Offset)offset).clone();
                QueryableIndexColumnSelectorFactory columnSelectorFactory = new QueryableIndexColumnSelectorFactory(QueryableIndexCursorSequenceBuilder.this.index, QueryableIndexCursorSequenceBuilder.this.virtualColumns, QueryableIndexCursorSequenceBuilder.this.descending, closer, baseCursorOffset.getBaseReadableOffset(), columnCache);
                DateTime myBucket = gran.toDateTime(inputInterval.getStartMillis());
                if (QueryableIndexCursorSequenceBuilder.this.postFilter == null) {
                    return new QueryableIndexCursor(baseCursorOffset, columnSelectorFactory, myBucket);
                }
                FilteredOffset filteredOffset = new FilteredOffset(baseCursorOffset, columnSelectorFactory, QueryableIndexCursorSequenceBuilder.this.descending, QueryableIndexCursorSequenceBuilder.this.postFilter, QueryableIndexCursorSequenceBuilder.this.bitmapIndexSelector);
                return new QueryableIndexCursor(filteredOffset, columnSelectorFactory, myBucket);
            }
        }), closer);
    }

    public VectorCursor buildVectorized(int vectorSize) {
        VectorOffset baseOffset;
        int endOffset;
        int startOffset;
        Preconditions.checkState(this.virtualColumns.size() == 0, "virtualColumns.size == 0");
        Preconditions.checkState(!this.descending, "!descending");
        HashMap<String, BaseColumn> columnCache = new HashMap<String, BaseColumn>();
        Closer closer = Closer.create();
        NumericColumn timestamps = null;
        if (this.interval.getStartMillis() > this.minDataTimestamp) {
            timestamps = (NumericColumn)this.index.getColumnHolder("__time").getColumn();
            closer.register(timestamps);
            startOffset = QueryableIndexCursorSequenceBuilder.timeSearch(timestamps, this.interval.getStartMillis(), 0, this.index.getNumRows());
        } else {
            startOffset = 0;
        }
        if (this.interval.getEndMillis() <= this.maxDataTimestamp) {
            if (timestamps == null) {
                timestamps = (NumericColumn)this.index.getColumnHolder("__time").getColumn();
                closer.register(timestamps);
            }
            endOffset = QueryableIndexCursorSequenceBuilder.timeSearch(timestamps, this.interval.getEndMillis(), startOffset, this.index.getNumRows());
        } else {
            endOffset = this.index.getNumRows();
        }
        VectorOffset vectorOffset = baseOffset = this.filterBitmap == null ? new NoFilterVectorOffset(vectorSize, startOffset, endOffset) : new BitmapVectorOffset(vectorSize, this.filterBitmap, startOffset, endOffset);
        if (this.postFilter == null) {
            return new QueryableIndexVectorCursor(this.index, baseOffset, closer, columnCache, vectorSize);
        }
        QueryableIndexVectorColumnSelectorFactory baseColumnSelectorFactory = new QueryableIndexVectorColumnSelectorFactory(this.index, baseOffset, closer, columnCache);
        FilteredVectorOffset filteredOffset = FilteredVectorOffset.create(baseOffset, baseColumnSelectorFactory, this.postFilter);
        return new QueryableIndexVectorCursor(this.index, filteredOffset, closer, columnCache, vectorSize);
    }

    @VisibleForTesting
    static int timeSearch(NumericColumn timeColumn, long timestamp, int startIndex, int endIndex) {
        long prevTimestamp = timestamp - 1L;
        int minIndex = startIndex;
        int maxIndex = endIndex - 1;
        while (minIndex <= maxIndex) {
            int currIndex = minIndex + maxIndex >>> 1;
            long currValue = timeColumn.getLongSingleValueRow(currIndex);
            if (currValue < prevTimestamp) {
                minIndex = currIndex + 1;
                continue;
            }
            if (currValue > prevTimestamp) {
                maxIndex = currIndex - 1;
                continue;
            }
            minIndex = currIndex;
            break;
        }
        while (minIndex < endIndex) {
            long currValue = timeColumn.getLongSingleValueRow(minIndex);
            if (currValue >= timestamp) {
                return minIndex;
            }
            ++minIndex;
        }
        return endIndex;
    }

    public static class DescendingTimestampCheckingOffset
    extends TimestampCheckingOffset {
        DescendingTimestampCheckingOffset(Offset baseOffset, NumericColumn timestamps, long timeLimit, boolean allWithinThreshold) {
            super(baseOffset, timestamps, timeLimit, allWithinThreshold);
        }

        @Override
        protected final boolean timeInRange(long current) {
            return current >= this.timeLimit;
        }

        public String toString() {
            return this.timeLimit + ">=" + (this.baseOffset.withinBounds() ? Long.valueOf(this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset())) : "OOB") + "::" + this.baseOffset;
        }

        @Override
        public Offset clone() {
            return new DescendingTimestampCheckingOffset(this.baseOffset.clone(), this.timestamps, this.timeLimit, this.allWithinThreshold);
        }
    }

    public static class AscendingTimestampCheckingOffset
    extends TimestampCheckingOffset {
        AscendingTimestampCheckingOffset(Offset baseOffset, NumericColumn timestamps, long timeLimit, boolean allWithinThreshold) {
            super(baseOffset, timestamps, timeLimit, allWithinThreshold);
        }

        @Override
        protected final boolean timeInRange(long current) {
            return current < this.timeLimit;
        }

        public String toString() {
            return (this.baseOffset.withinBounds() ? Long.valueOf(this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset())) : "OOB") + "<" + this.timeLimit + "::" + this.baseOffset;
        }

        @Override
        public Offset clone() {
            return new AscendingTimestampCheckingOffset(this.baseOffset.clone(), this.timestamps, this.timeLimit, this.allWithinThreshold);
        }
    }

    public static abstract class TimestampCheckingOffset
    extends Offset {
        final Offset baseOffset;
        final NumericColumn timestamps;
        final long timeLimit;
        final boolean allWithinThreshold;

        TimestampCheckingOffset(Offset baseOffset, NumericColumn timestamps, long timeLimit, boolean allWithinThreshold) {
            this.baseOffset = baseOffset;
            this.timestamps = timestamps;
            this.timeLimit = timeLimit;
            this.allWithinThreshold = allWithinThreshold;
        }

        @Override
        public int getOffset() {
            return this.baseOffset.getOffset();
        }

        @Override
        public boolean withinBounds() {
            if (!this.baseOffset.withinBounds()) {
                return false;
            }
            if (this.allWithinThreshold) {
                return true;
            }
            return this.timeInRange(this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset()));
        }

        @Override
        public void reset() {
            this.baseOffset.reset();
        }

        @Override
        public ReadableOffset getBaseReadableOffset() {
            return this.baseOffset.getBaseReadableOffset();
        }

        protected abstract boolean timeInRange(long var1);

        @Override
        public void increment() {
            this.baseOffset.increment();
        }

        @Override
        public Offset clone() {
            throw new IllegalStateException("clone");
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("baseOffset", this.baseOffset);
            inspector.visit("timestamps", this.timestamps);
            inspector.visit("allWithinThreshold", this.allWithinThreshold);
        }
    }

    private static class QueryableIndexCursor
    implements HistoricalCursor {
        private final Offset cursorOffset;
        private final ColumnSelectorFactory columnSelectorFactory;
        private final DateTime bucketStart;

        QueryableIndexCursor(Offset cursorOffset, ColumnSelectorFactory columnSelectorFactory, DateTime bucketStart) {
            this.cursorOffset = cursorOffset;
            this.columnSelectorFactory = columnSelectorFactory;
            this.bucketStart = bucketStart;
        }

        @Override
        public Offset getOffset() {
            return this.cursorOffset;
        }

        @Override
        public ColumnSelectorFactory getColumnSelectorFactory() {
            return this.columnSelectorFactory;
        }

        @Override
        public DateTime getTime() {
            return this.bucketStart;
        }

        @Override
        public void advance() {
            this.cursorOffset.increment();
            BaseQuery.checkInterrupted();
        }

        @Override
        public void advanceUninterruptibly() {
            this.cursorOffset.increment();
        }

        @Override
        public boolean isDone() {
            return !this.cursorOffset.withinBounds();
        }

        @Override
        public boolean isDoneOrInterrupted() {
            return this.isDone() || Thread.currentThread().isInterrupted();
        }

        @Override
        public void reset() {
            this.cursorOffset.reset();
        }
    }

    private static class QueryableIndexVectorCursor
    implements VectorCursor {
        private final Closer closer;
        private final int vectorSize;
        private final VectorOffset offset;
        private final VectorColumnSelectorFactory columnSelectorFactory;

        public QueryableIndexVectorCursor(QueryableIndex index, VectorOffset offset, Closer closer, Map<String, BaseColumn> columnCache, int vectorSize) {
            this.offset = offset;
            this.closer = closer;
            this.vectorSize = vectorSize;
            this.columnSelectorFactory = new QueryableIndexVectorColumnSelectorFactory(index, offset, closer, columnCache);
        }

        @Override
        public int getMaxVectorSize() {
            return this.vectorSize;
        }

        @Override
        public int getCurrentVectorSize() {
            return this.offset.getCurrentVectorSize();
        }

        @Override
        public VectorColumnSelectorFactory getColumnSelectorFactory() {
            return this.columnSelectorFactory;
        }

        @Override
        public void advance() {
            this.offset.advance();
            BaseQuery.checkInterrupted();
        }

        @Override
        public boolean isDone() {
            return this.offset.isDone();
        }

        @Override
        public void reset() {
            this.offset.reset();
        }

        @Override
        public void close() {
            try {
                this.closer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

