/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.Closer;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.NilColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.SingleScanTimeDimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumns;
import org.apache.hive.druid.org.apache.druid.segment.column.BaseColumn;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnHolder;
import org.apache.hive.druid.org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.apache.hive.druid.org.apache.druid.segment.data.ReadableOffset;

class QueryableIndexColumnSelectorFactory
implements ColumnSelectorFactory {
    private final QueryableIndex index;
    private final VirtualColumns virtualColumns;
    private final boolean descending;
    private final Closer closer;
    protected final ReadableOffset offset;
    private final Map<String, BaseColumn> columnCache;
    private final Map<DimensionSpec, DimensionSelector> dimensionSelectorCache;
    private final Map<String, ColumnValueSelector> valueSelectorCache;

    QueryableIndexColumnSelectorFactory(QueryableIndex index, VirtualColumns virtualColumns, boolean descending, Closer closer, ReadableOffset offset, Map<String, BaseColumn> columnCache) {
        this.index = index;
        this.virtualColumns = virtualColumns;
        this.descending = descending;
        this.closer = closer;
        this.offset = offset;
        this.columnCache = columnCache;
        this.dimensionSelectorCache = new HashMap<DimensionSpec, DimensionSelector>();
        this.valueSelectorCache = new HashMap<String, ColumnValueSelector>();
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        Function<DimensionSpec, DimensionSelector> mappingFunction = spec -> {
            if (this.virtualColumns.exists(spec.getDimension())) {
                DimensionSelector dimensionSelector = this.virtualColumns.makeDimensionSelector(dimensionSpec, this.index, this.offset);
                if (dimensionSelector == null) {
                    return this.virtualColumns.makeDimensionSelector(dimensionSpec, this);
                }
                return dimensionSelector;
            }
            return spec.decorate(this.makeDimensionSelectorUndecorated((DimensionSpec)spec));
        };
        DimensionSelector dimensionSelector = this.dimensionSelectorCache.get(dimensionSpec);
        if (dimensionSelector == null) {
            dimensionSelector = mappingFunction.apply(dimensionSpec);
            this.dimensionSelectorCache.put(dimensionSpec, dimensionSelector);
        }
        return dimensionSelector;
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        String dimension = dimensionSpec.getDimension();
        ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder == null) {
            return DimensionSelector.constant(null, extractionFn);
        }
        if (dimension.equals("__time")) {
            return new SingleScanTimeDimensionSelector(this.makeColumnValueSelector(dimension), extractionFn, this.descending);
        }
        ValueType type = columnHolder.getCapabilities().getType();
        if (type.isNumeric()) {
            return type.makeNumericWrappingDimensionSelector(this.makeColumnValueSelector(dimension), extractionFn);
        }
        DictionaryEncodedColumn column = this.getCachedColumn(dimension, DictionaryEncodedColumn.class);
        if (column != null) {
            return column.makeDimensionSelector(this.offset, extractionFn);
        }
        return DimensionSelector.constant(null, extractionFn);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
        Function<String, ColumnValueSelector> mappingFunction = name -> {
            if (this.virtualColumns.exists(columnName)) {
                ColumnValueSelector<?> selector = this.virtualColumns.makeColumnValueSelector(columnName, this.index, this.offset);
                if (selector == null) {
                    return this.virtualColumns.makeColumnValueSelector(columnName, this);
                }
                return selector;
            }
            BaseColumn column = this.getCachedColumn(columnName, BaseColumn.class);
            if (column != null) {
                return column.makeColumnValueSelector(this.offset);
            }
            return NilColumnValueSelector.instance();
        };
        ColumnValueSelector columnValueSelector = this.valueSelectorCache.get(columnName);
        if (columnValueSelector == null) {
            columnValueSelector = mappingFunction.apply(columnName);
            this.valueSelectorCache.put(columnName, columnValueSelector);
        }
        return columnValueSelector;
    }

    @Nullable
    private <T extends BaseColumn> T getCachedColumn(String columnName, Class<T> clazz) {
        return (T)this.columnCache.computeIfAbsent(columnName, name -> {
            ColumnHolder holder = this.index.getColumnHolder((String)name);
            if (holder != null && clazz.isAssignableFrom(holder.getColumn().getClass())) {
                return this.closer.register(holder.getColumn());
            }
            return null;
        });
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.getColumnCapabilities(columnName);
        }
        return QueryableIndexStorageAdapter.getColumnCapabilities(this.index, columnName);
    }
}

