/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.GenericColumnSerializer;
import org.apache.hive.druid.org.apache.druid.segment.IndexIO;
import org.apache.hive.druid.org.apache.druid.segment.data.ColumnarLongsSerializer;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class LongColumnSerializer
implements GenericColumnSerializer<Object> {
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final String filenameBase;
    private final ByteOrder byteOrder;
    private final CompressionStrategy compression;
    private final CompressionFactory.LongEncodingStrategy encoding;
    private ColumnarLongsSerializer writer;

    public static LongColumnSerializer create(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, CompressionStrategy compression, CompressionFactory.LongEncodingStrategy encoding) {
        return new LongColumnSerializer(segmentWriteOutMedium, filenameBase, IndexIO.BYTE_ORDER, compression, encoding);
    }

    private LongColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder byteOrder, CompressionStrategy compression, CompressionFactory.LongEncodingStrategy encoding) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.filenameBase = filenameBase;
        this.byteOrder = byteOrder;
        this.compression = compression;
        this.encoding = encoding;
    }

    @Override
    public void open() throws IOException {
        this.writer = CompressionFactory.getLongSerializer(this.segmentWriteOutMedium, StringUtils.format("%s.long_column", this.filenameBase), this.byteOrder, this.encoding, this.compression);
        this.writer.open();
    }

    @Override
    public void serialize(ColumnValueSelector<?> selector) throws IOException {
        this.writer.add(selector.getLong());
    }

    @Override
    public long getSerializedSize() throws IOException {
        return this.writer.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writer.writeTo(channel, smoosher);
    }
}

