/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import com.google.inject.ImplementedBy;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.PeekingIterator;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.common.utils.SerializerUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionMergerV9;
import org.apache.hive.druid.org.apache.druid.segment.ForwardingRowIterator;
import org.apache.hive.druid.org.apache.druid.segment.IndexMergerV9;
import org.apache.hive.druid.org.apache.druid.segment.IndexSpec;
import org.apache.hive.druid.org.apache.druid.segment.IndexableAdapter;
import org.apache.hive.druid.org.apache.druid.segment.ProgressIndicator;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.hive.druid.org.apache.druid.segment.RowPointer;
import org.apache.hive.druid.org.apache.druid.segment.TimeAndDimsPointer;
import org.apache.hive.druid.org.apache.druid.segment.TransformableRowIterator;
import org.apache.hive.druid.org.apache.druid.segment.data.Indexed;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Interval;

@ImplementedBy(value=IndexMergerV9.class)
public interface IndexMerger {
    public static final Logger log = new Logger(IndexMerger.class);
    public static final SerializerUtils SERIALIZER_UTILS = new SerializerUtils();
    public static final int INVALID_ROW = -1;

    public static List<String> getMergedDimensionsFromQueryableIndexes(List<QueryableIndex> indexes) {
        return IndexMerger.getMergedDimensions(IndexMerger.toIndexableAdapters(indexes));
    }

    public static List<IndexableAdapter> toIndexableAdapters(List<QueryableIndex> indexes) {
        return indexes.stream().map(QueryableIndexIndexableAdapter::new).collect(Collectors.toList());
    }

    public static List<String> getMergedDimensions(List<IndexableAdapter> indexes) {
        if (indexes.size() == 0) {
            return ImmutableList.of();
        }
        List<String> commonDimOrder = IndexMerger.getLongestSharedDimOrder(indexes);
        if (commonDimOrder == null) {
            log.warn("Indexes have incompatible dimension orders, using lexicographic order.", new Object[0]);
            return IndexMerger.getLexicographicMergedDimensions(indexes);
        }
        return commonDimOrder;
    }

    @Nullable
    public static List<String> getLongestSharedDimOrder(List<IndexableAdapter> indexes) {
        int maxSize = 0;
        List<String> orderingCandidate = null;
        for (IndexableAdapter index : indexes) {
            int iterSize = index.getDimensionNames().size();
            if (iterSize <= maxSize) continue;
            maxSize = iterSize;
            orderingCandidate = index.getDimensionNames();
        }
        if (orderingCandidate == null) {
            return null;
        }
        for (IndexableAdapter index : indexes) {
            Iterator candidateIter = orderingCandidate.iterator();
            for (String matchDim : index.getDimensionNames()) {
                boolean matched = false;
                while (candidateIter.hasNext()) {
                    String nextDim = (String)candidateIter.next();
                    if (!matchDim.equals(nextDim)) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                return null;
            }
        }
        return ImmutableList.copyOf(orderingCandidate);
    }

    public static List<String> getLexicographicMergedDimensions(List<IndexableAdapter> indexes) {
        return IndexMerger.mergeIndexed(Lists.transform(indexes, new Function<IndexableAdapter, Iterable<String>>(){

            @Override
            public Iterable<String> apply(@Nullable IndexableAdapter input) {
                return input.getDimensionNames();
            }
        }));
    }

    public static <T extends Comparable<? super T>> ArrayList<T> mergeIndexed(List<Iterable<T>> indexedLists) {
        TreeSet retVal = new TreeSet(Comparators.naturalNullsFirst());
        for (Iterable<T> indexedList : indexedLists) {
            for (Comparable val : indexedList) {
                retVal.add(val);
            }
        }
        return Lists.newArrayList(retVal);
    }

    public File persist(IncrementalIndex var1, File var2, IndexSpec var3, @Nullable SegmentWriteOutMediumFactory var4) throws IOException;

    public File persist(IncrementalIndex var1, Interval var2, File var3, IndexSpec var4, @Nullable SegmentWriteOutMediumFactory var5) throws IOException;

    public File persist(IncrementalIndex var1, Interval var2, File var3, IndexSpec var4, ProgressIndicator var5, @Nullable SegmentWriteOutMediumFactory var6) throws IOException;

    public File mergeQueryableIndex(List<QueryableIndex> var1, boolean var2, AggregatorFactory[] var3, File var4, IndexSpec var5, @Nullable SegmentWriteOutMediumFactory var6) throws IOException;

    public File mergeQueryableIndex(List<QueryableIndex> var1, boolean var2, AggregatorFactory[] var3, File var4, IndexSpec var5, ProgressIndicator var6, @Nullable SegmentWriteOutMediumFactory var7) throws IOException;

    @VisibleForTesting
    public File merge(List<IndexableAdapter> var1, boolean var2, AggregatorFactory[] var3, File var4, IndexSpec var5) throws IOException;

    public File convert(File var1, File var2, IndexSpec var3) throws IOException;

    public File append(List<IndexableAdapter> var1, AggregatorFactory[] var2, File var3, IndexSpec var4, @Nullable SegmentWriteOutMediumFactory var5) throws IOException;

    public static TransformableRowIterator toMergedIndexRowIterator(TransformableRowIterator sourceRowIterator, int indexNumber, List<DimensionMergerV9> mergers) {
        RowPointer sourceRowPointer = sourceRowIterator.getPointer();
        TimeAndDimsPointer markedSourceRowPointer = sourceRowIterator.getMarkedPointer();
        boolean anySelectorChanged = false;
        ColumnValueSelector[] convertedDimensionSelectors = new ColumnValueSelector[mergers.size()];
        ColumnValueSelector[] convertedMarkedDimensionSelectors = new ColumnValueSelector[mergers.size()];
        for (int i = 0; i < mergers.size(); ++i) {
            ColumnValueSelector convertedDimensionSelector;
            ColumnValueSelector sourceDimensionSelector = sourceRowPointer.getDimensionSelector(i);
            convertedDimensionSelectors[i] = convertedDimensionSelector = mergers.get(i).convertSortedSegmentRowValuesToMergedRowValues(indexNumber, sourceDimensionSelector);
            anySelectorChanged |= convertedDimensionSelector != sourceDimensionSelector;
            convertedMarkedDimensionSelectors[i] = mergers.get(i).convertSortedSegmentRowValuesToMergedRowValues(indexNumber, markedSourceRowPointer.getDimensionSelector(i));
        }
        if (!anySelectorChanged) {
            return sourceRowIterator;
        }
        return IndexMerger.makeRowIteratorWithConvertedDimensionColumns(sourceRowIterator, convertedDimensionSelectors, convertedMarkedDimensionSelectors);
    }

    public static TransformableRowIterator makeRowIteratorWithConvertedDimensionColumns(TransformableRowIterator sourceRowIterator, ColumnValueSelector[] convertedDimensionSelectors, ColumnValueSelector[] convertedMarkedDimensionSelectors) {
        final RowPointer convertedRowPointer = sourceRowIterator.getPointer().withDimensionSelectors(convertedDimensionSelectors);
        final TimeAndDimsPointer convertedMarkedRowPointer = sourceRowIterator.getMarkedPointer().withDimensionSelectors(convertedMarkedDimensionSelectors);
        return new ForwardingRowIterator(sourceRowIterator){

            @Override
            public RowPointer getPointer() {
                return convertedRowPointer;
            }

            @Override
            public TimeAndDimsPointer getMarkedPointer() {
                return convertedMarkedRowPointer;
            }
        };
    }

    public static class DictionaryMergeIterator
    implements CloseableIterator<String> {
        static final Comparator<Pair<Integer, PeekingIterator<String>>> NULLS_FIRST_PEEKING_COMPARATOR = (lhs, rhs) -> {
            String left = (String)((PeekingIterator)lhs.rhs).peek();
            String right = (String)((PeekingIterator)rhs.rhs).peek();
            if (left == null) {
                return right == null ? 0 : -1;
            }
            if (right == null) {
                return 1;
            }
            return left.compareTo(right);
        };
        protected final IntBuffer[] conversions;
        protected final List<Pair<ByteBuffer, Integer>> directBufferAllocations = new ArrayList<Pair<ByteBuffer, Integer>>();
        protected final PriorityQueue<Pair<Integer, PeekingIterator<String>>> pQueue;
        protected int counter;

        DictionaryMergeIterator(Indexed<String>[] dimValueLookups, boolean useDirect) {
            this.pQueue = new PriorityQueue<Pair<Integer, PeekingIterator<String>>>(dimValueLookups.length, NULLS_FIRST_PEEKING_COMPARATOR);
            this.conversions = new IntBuffer[dimValueLookups.length];
            long mergeBufferTotalSize = 0L;
            for (int i = 0; i < this.conversions.length; ++i) {
                if (dimValueLookups[i] == null) continue;
                Indexed<String> indexed = dimValueLookups[i];
                if (useDirect) {
                    int allocationSize = indexed.size() * 4;
                    log.trace("Allocating dictionary merging direct buffer with size[%,d]", allocationSize);
                    mergeBufferTotalSize += (long)allocationSize;
                    ByteBuffer conversionDirectBuffer = ByteBuffer.allocateDirect(allocationSize);
                    this.conversions[i] = conversionDirectBuffer.asIntBuffer();
                    this.directBufferAllocations.add(new Pair<ByteBuffer, Integer>(conversionDirectBuffer, allocationSize));
                } else {
                    this.conversions[i] = IntBuffer.allocate(indexed.size());
                    mergeBufferTotalSize += (long)indexed.size();
                }
                PeekingIterator iter = Iterators.peekingIterator(Iterators.transform(indexed.iterator(), NullHandling::nullToEmptyIfNeeded));
                if (!iter.hasNext()) continue;
                this.pQueue.add(Pair.of(i, iter));
            }
            log.debug("Allocated [%,d] bytes of dictionary merging direct buffers", mergeBufferTotalSize);
        }

        @Override
        public boolean hasNext() {
            return !this.pQueue.isEmpty();
        }

        @Override
        public String next() {
            Pair smallest = (Pair)this.pQueue.remove();
            if (smallest == null) {
                throw new NoSuchElementException();
            }
            String value = this.writeTranslate(smallest, this.counter);
            while (!this.pQueue.isEmpty() && Objects.equals(value, ((PeekingIterator)this.pQueue.peek().rhs).peek())) {
                this.writeTranslate((Pair)this.pQueue.remove(), this.counter);
            }
            ++this.counter;
            return value;
        }

        boolean needConversion(int index) {
            IntBuffer readOnly = this.conversions[index].asReadOnlyBuffer();
            readOnly.rewind();
            int i = 0;
            while (readOnly.hasRemaining()) {
                if (i != readOnly.get()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private String writeTranslate(Pair<Integer, PeekingIterator<String>> smallest, int counter) {
            int index = (Integer)smallest.lhs;
            String value = (String)((PeekingIterator)smallest.rhs).next();
            this.conversions[index].put(counter);
            if (((PeekingIterator)smallest.rhs).hasNext()) {
                this.pQueue.add(smallest);
            }
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void close() {
            long mergeBufferTotalSize = 0L;
            for (Pair<ByteBuffer, Integer> bufferAllocation : this.directBufferAllocations) {
                log.trace("Freeing dictionary merging direct buffer with size[%,d]", bufferAllocation.rhs);
                mergeBufferTotalSize += (long)((Integer)bufferAllocation.rhs).intValue();
                ByteBufferUtils.free((ByteBuffer)bufferAllocation.lhs);
            }
            log.debug("Freed [%,d] bytes of dictionary merging direct buffers", mergeBufferTotalSize);
        }
    }

    public static class IndexSeekerWithConversion
    implements IndexSeeker {
        private final IntBuffer dimConversions;
        private int currIndex;
        private int currVal;
        private int lastVal;

        IndexSeekerWithConversion(IntBuffer dimConversions) {
            this.dimConversions = dimConversions;
            this.currIndex = 0;
            this.currVal = -1;
            this.lastVal = -1;
        }

        @Override
        public int seek(int dictId) {
            if (this.dimConversions == null) {
                return -1;
            }
            if (this.lastVal != -1) {
                if (dictId <= this.lastVal) {
                    throw new ISE("Value dictId[%d] is less than the last value dictId[%d] I have, cannot be.", dictId, this.lastVal);
                }
                return -1;
            }
            if (this.currVal == -1) {
                this.currVal = this.dimConversions.get();
            }
            if (this.currVal == dictId) {
                int ret = this.currIndex++;
                if (this.dimConversions.hasRemaining()) {
                    this.currVal = this.dimConversions.get();
                } else {
                    this.lastVal = dictId;
                }
                return ret;
            }
            if (this.currVal < dictId) {
                throw new ISE("Skipped currValue dictId[%d], currIndex[%d]; incoming value dictId[%d]", this.currVal, this.currIndex, dictId);
            }
            return -1;
        }
    }

    public static interface IndexSeeker {
        public static final int NOT_EXIST = -1;
        public static final int NOT_INIT = -1;

        public int seek(int var1);
    }
}

