/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.primitives.Doubles;
import org.apache.hive.druid.com.google.common.primitives.Floats;
import org.apache.hive.druid.org.apache.druid.common.guava.GuavaUtils;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.hive.druid.org.apache.druid.query.ColumnSelectorPlus;
import org.apache.hive.druid.org.apache.druid.query.dimension.ColumnSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.VectorColumnStrategizer;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionHandler;
import org.apache.hive.druid.org.apache.druid.segment.DoubleDimensionHandler;
import org.apache.hive.druid.org.apache.druid.segment.FloatDimensionHandler;
import org.apache.hive.druid.org.apache.druid.segment.LongDimensionHandler;
import org.apache.hive.druid.org.apache.druid.segment.StringDimensionHandler;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public final class DimensionHandlerUtils {
    public static final Double ZERO_DOUBLE = 0.0;
    public static final Float ZERO_FLOAT = Float.valueOf(0.0f);
    public static final Long ZERO_LONG = 0L;
    public static final ColumnCapabilities DEFAULT_STRING_CAPABILITIES = new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(true).setHasBitmapIndexes(true);

    private DimensionHandlerUtils() {
    }

    public static DimensionHandler<?, ?, ?> getHandlerFromCapabilities(String dimensionName, @Nullable ColumnCapabilities capabilities, @Nullable DimensionSchema.MultiValueHandling multiValueHandling) {
        if (capabilities == null) {
            return new StringDimensionHandler(dimensionName, multiValueHandling, true);
        }
        DimensionSchema.MultiValueHandling multiValueHandling2 = multiValueHandling = multiValueHandling == null ? DimensionSchema.MultiValueHandling.ofDefault() : multiValueHandling;
        if (capabilities.getType() == ValueType.STRING) {
            if (!capabilities.isDictionaryEncoded()) {
                throw new IAE("String column must have dictionary encoding.", new Object[0]);
            }
            return new StringDimensionHandler(dimensionName, multiValueHandling, capabilities.hasBitmapIndexes());
        }
        if (capabilities.getType() == ValueType.LONG) {
            return new LongDimensionHandler(dimensionName);
        }
        if (capabilities.getType() == ValueType.FLOAT) {
            return new FloatDimensionHandler(dimensionName);
        }
        if (capabilities.getType() == ValueType.DOUBLE) {
            return new DoubleDimensionHandler(dimensionName);
        }
        return new StringDimensionHandler(dimensionName, multiValueHandling, true);
    }

    public static List<ValueType> getValueTypesFromDimensionSpecs(List<DimensionSpec> dimSpecs) {
        ArrayList<ValueType> types = new ArrayList<ValueType>(dimSpecs.size());
        for (DimensionSpec dimSpec : dimSpecs) {
            types.add(dimSpec.getOutputType());
        }
        return types;
    }

    public static <Strategy extends ColumnSelectorStrategy> ColumnSelectorPlus<Strategy> createColumnSelectorPlus(ColumnSelectorStrategyFactory<Strategy> strategyFactory, DimensionSpec dimensionSpec, ColumnSelectorFactory cursor) {
        return DimensionHandlerUtils.createColumnSelectorPluses(strategyFactory, ImmutableList.of(dimensionSpec), cursor)[0];
    }

    public static <Strategy extends ColumnSelectorStrategy> ColumnSelectorPlus<Strategy>[] createColumnSelectorPluses(ColumnSelectorStrategyFactory<Strategy> strategyFactory, List<DimensionSpec> dimensionSpecs, ColumnSelectorFactory columnSelectorFactory) {
        int dimCount = dimensionSpecs.size();
        ColumnSelectorPlus[] dims = new ColumnSelectorPlus[dimCount];
        for (int i = 0; i < dimCount; ++i) {
            ColumnSelectorPlus<Strategy> selectorPlus;
            DimensionSpec dimSpec = dimensionSpecs.get(i);
            String dimName = dimSpec.getDimension();
            ColumnValueSelector<?> selector = DimensionHandlerUtils.getColumnValueSelectorFromDimensionSpec(dimSpec, columnSelectorFactory);
            Strategy strategy = DimensionHandlerUtils.makeStrategy(strategyFactory, dimSpec, columnSelectorFactory.getColumnCapabilities(dimSpec.getDimension()), selector);
            dims[i] = selectorPlus = new ColumnSelectorPlus<Strategy>(dimName, dimSpec.getOutputName(), strategy, selector);
        }
        return dims;
    }

    private static ColumnValueSelector<?> getColumnValueSelectorFromDimensionSpec(DimensionSpec dimSpec, ColumnSelectorFactory columnSelectorFactory) {
        String dimName = dimSpec.getDimension();
        ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(dimName);
        if ((capabilities = DimensionHandlerUtils.getEffectiveCapabilities(dimSpec, capabilities)).getType() == ValueType.STRING) {
            return columnSelectorFactory.makeDimensionSelector(dimSpec);
        }
        return columnSelectorFactory.makeColumnValueSelector(dimSpec.getDimension());
    }

    private static ColumnCapabilities getEffectiveCapabilities(DimensionSpec dimSpec, @Nullable ColumnCapabilities capabilities) {
        if (capabilities == null) {
            capabilities = DEFAULT_STRING_CAPABILITIES;
        }
        if (capabilities.getType() == ValueType.COMPLEX) {
            capabilities = DEFAULT_STRING_CAPABILITIES;
        }
        if (dimSpec.getExtractionFn() != null) {
            capabilities = DEFAULT_STRING_CAPABILITIES;
        }
        if (ValueType.isNumeric(capabilities.getType()) && dimSpec.mustDecorate()) {
            capabilities = DEFAULT_STRING_CAPABILITIES;
        }
        return capabilities;
    }

    private static <Strategy extends ColumnSelectorStrategy> Strategy makeStrategy(ColumnSelectorStrategyFactory<Strategy> strategyFactory, DimensionSpec dimSpec, @Nullable ColumnCapabilities capabilities, ColumnValueSelector<?> selector) {
        capabilities = DimensionHandlerUtils.getEffectiveCapabilities(dimSpec, capabilities);
        return strategyFactory.makeColumnSelectorStrategy(capabilities, selector);
    }

    public static <T> T makeVectorProcessor(String column, VectorColumnStrategizer<T> strategyFactory, VectorColumnSelectorFactory selectorFactory) {
        return DimensionHandlerUtils.makeVectorProcessor(DefaultDimensionSpec.of(column), strategyFactory, selectorFactory);
    }

    public static <T> T makeVectorProcessor(DimensionSpec dimensionSpec, VectorColumnStrategizer<T> strategyFactory, VectorColumnSelectorFactory selectorFactory) {
        ColumnCapabilities capabilities = DimensionHandlerUtils.getEffectiveCapabilities(dimensionSpec, selectorFactory.getColumnCapabilities(dimensionSpec.getDimension()));
        ValueType type = capabilities.getType();
        if (type == ValueType.STRING) {
            if (capabilities.hasMultipleValues()) {
                return strategyFactory.makeMultiValueDimensionStrategy(selectorFactory.makeMultiValueDimensionSelector(dimensionSpec));
            }
            return strategyFactory.makeSingleValueDimensionStrategy(selectorFactory.makeSingleValueDimensionSelector(dimensionSpec));
        }
        Preconditions.checkState(dimensionSpec.getExtractionFn() == null && !dimensionSpec.mustDecorate(), "Uh oh, was about to try to make a value selector for type[%s] with a dimensionSpec of class[%s] that requires decoration. Possible bug.", new Object[]{type, dimensionSpec.getClass().getName()});
        if (type == ValueType.LONG) {
            return strategyFactory.makeLongStrategy(selectorFactory.makeValueSelector(dimensionSpec.getDimension()));
        }
        if (type == ValueType.FLOAT) {
            return strategyFactory.makeFloatStrategy(selectorFactory.makeValueSelector(dimensionSpec.getDimension()));
        }
        if (type == ValueType.DOUBLE) {
            return strategyFactory.makeDoubleStrategy(selectorFactory.makeValueSelector(dimensionSpec.getDimension()));
        }
        throw new ISE("Unsupported type[%s]", new Object[]{capabilities.getType()});
    }

    @Nullable
    public static String convertObjectToString(@Nullable Object valObj) {
        if (valObj == null) {
            return null;
        }
        return valObj.toString();
    }

    @Nullable
    public static Long convertObjectToLong(@Nullable Object valObj) {
        return DimensionHandlerUtils.convertObjectToLong(valObj, false);
    }

    @Nullable
    public static Long convertObjectToLong(@Nullable Object valObj, boolean reportParseExceptions) {
        if (valObj == null) {
            return null;
        }
        if (valObj instanceof Long) {
            return (Long)valObj;
        }
        if (valObj instanceof Number) {
            return ((Number)valObj).longValue();
        }
        if (valObj instanceof String) {
            Long ret = DimensionHandlerUtils.getExactLongFromDecimalString((String)valObj);
            if (reportParseExceptions && ret == null) {
                throw new ParseException("could not convert value [%s] to long", valObj);
            }
            return ret;
        }
        throw new ParseException("Unknown type[%s]", valObj.getClass());
    }

    @Nullable
    public static Float convertObjectToFloat(@Nullable Object valObj) {
        return DimensionHandlerUtils.convertObjectToFloat(valObj, false);
    }

    @Nullable
    public static Float convertObjectToFloat(@Nullable Object valObj, boolean reportParseExceptions) {
        if (valObj == null) {
            return null;
        }
        if (valObj instanceof Float) {
            return (Float)valObj;
        }
        if (valObj instanceof Number) {
            return Float.valueOf(((Number)valObj).floatValue());
        }
        if (valObj instanceof String) {
            Float ret = Floats.tryParse((String)valObj);
            if (reportParseExceptions && ret == null) {
                throw new ParseException("could not convert value [%s] to float", valObj);
            }
            return ret;
        }
        throw new ParseException("Unknown type[%s]", valObj.getClass());
    }

    @Nullable
    public static Comparable<?> convertObjectToType(@Nullable Object obj, ValueType type, boolean reportParseExceptions) {
        Preconditions.checkNotNull(type, "type");
        switch (type) {
            case LONG: {
                return DimensionHandlerUtils.convertObjectToLong(obj, reportParseExceptions);
            }
            case FLOAT: {
                return DimensionHandlerUtils.convertObjectToFloat(obj, reportParseExceptions);
            }
            case DOUBLE: {
                return DimensionHandlerUtils.convertObjectToDouble(obj, reportParseExceptions);
            }
            case STRING: {
                return DimensionHandlerUtils.convertObjectToString(obj);
            }
        }
        throw new IAE("Type[%s] is not supported for dimensions!", new Object[]{type});
    }

    public static int compareObjectsAsType(@Nullable Object lhs, @Nullable Object rhs, ValueType type) {
        return Comparators.naturalNullsFirst().compare(DimensionHandlerUtils.convertObjectToType(lhs, type), DimensionHandlerUtils.convertObjectToType(rhs, type));
    }

    @Nullable
    public static Comparable<?> convertObjectToType(@Nullable Object obj, ValueType type) {
        return DimensionHandlerUtils.convertObjectToType(obj, Preconditions.checkNotNull(type, "type"), false);
    }

    public static Function<Object, Comparable<?>> converterFromTypeToType(ValueType fromType, ValueType toType) {
        if (fromType == toType) {
            return Function.identity();
        }
        return obj -> DimensionHandlerUtils.convertObjectToType(obj, toType);
    }

    @Nullable
    public static Double convertObjectToDouble(@Nullable Object valObj) {
        return DimensionHandlerUtils.convertObjectToDouble(valObj, false);
    }

    @Nullable
    public static Double convertObjectToDouble(@Nullable Object valObj, boolean reportParseExceptions) {
        if (valObj == null) {
            return null;
        }
        if (valObj instanceof Double) {
            return (Double)valObj;
        }
        if (valObj instanceof Number) {
            return ((Number)valObj).doubleValue();
        }
        if (valObj instanceof String) {
            Double ret = Doubles.tryParse((String)valObj);
            if (reportParseExceptions && ret == null) {
                throw new ParseException("could not convert value [%s] to double", valObj);
            }
            return ret;
        }
        throw new ParseException("Unknown type[%s]", valObj.getClass());
    }

    @Nullable
    public static Long getExactLongFromDecimalString(String decimalStr) {
        BigDecimal convertedBD;
        Long val = GuavaUtils.tryParseLong(decimalStr);
        if (val != null) {
            return val;
        }
        try {
            convertedBD = new BigDecimal(decimalStr);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        try {
            return convertedBD.longValueExact();
        }
        catch (ArithmeticException ae) {
            return null;
        }
    }

    public static Double nullToZero(@Nullable Double number) {
        return number == null ? ZERO_DOUBLE : number;
    }

    public static Long nullToZero(@Nullable Long number) {
        return number == null ? ZERO_LONG : number;
    }

    public static Float nullToZero(@Nullable Float number) {
        return number == null ? ZERO_FLOAT : number;
    }

    public static Number nullToZero(@Nullable Number number) {
        return number == null ? (Number)ZERO_DOUBLE : (Number)number;
    }
}

