/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.topn;

import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.org.apache.druid.collections.NonBlockingPool;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Global;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.query.ChainedExecutionQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.org.apache.druid.query.QueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.QueryWatcher;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNQuery;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNQueryEngine;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNQueryMetrics;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNResultValue;
import org.apache.hive.druid.org.apache.druid.segment.Segment;

public class TopNQueryRunnerFactory
implements QueryRunnerFactory<Result<TopNResultValue>, TopNQuery> {
    private final NonBlockingPool<ByteBuffer> computationBufferPool;
    private final TopNQueryQueryToolChest toolchest;
    private final QueryWatcher queryWatcher;

    @Inject
    public TopNQueryRunnerFactory(@Global NonBlockingPool<ByteBuffer> computationBufferPool, TopNQueryQueryToolChest toolchest, QueryWatcher queryWatcher) {
        this.computationBufferPool = computationBufferPool;
        this.toolchest = toolchest;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> createRunner(final Segment segment) {
        final TopNQueryEngine queryEngine = new TopNQueryEngine(this.computationBufferPool);
        return new QueryRunner<Result<TopNResultValue>>(){

            @Override
            public Sequence<Result<TopNResultValue>> run(QueryPlus<Result<TopNResultValue>> input, ResponseContext responseContext) {
                if (!(input.getQuery() instanceof TopNQuery)) {
                    throw new ISE("Got a [%s] which isn't a %s", input.getClass(), TopNQuery.class);
                }
                TopNQuery query = (TopNQuery)input.getQuery();
                return queryEngine.query(query, segment.asStorageAdapter(), (TopNQueryMetrics)input.getQueryMetrics());
            }
        };
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<TopNResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<TopNResultValue>>(queryExecutor, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<TopNResultValue>, TopNQuery> getToolchest() {
        return this.toolchest;
    }
}

