/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.topn;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparator;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparators;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNAlgorithmSelector;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNLexicographicResultBuilder;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNMetricSpecBuilder;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNResultBuilder;
import org.joda.time.DateTime;

public class DimensionTopNMetricSpec
implements TopNMetricSpec {
    private static final StringComparator DEFAULT_ORDERING = StringComparators.LEXICOGRAPHIC;
    private static final byte STRING_SEPARATOR = -1;
    private static final byte CACHE_TYPE_ID = 4;
    private final String previousStop;
    private final StringComparator ordering;

    @JsonCreator
    public DimensionTopNMetricSpec(@JsonProperty(value="previousStop") String previousStop, @JsonProperty(value="ordering") StringComparator ordering) {
        this.previousStop = previousStop;
        this.ordering = ordering == null ? DEFAULT_ORDERING : ordering;
    }

    @Override
    public void verifyPreconditions(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
    }

    @JsonProperty
    public String getPreviousStop() {
        return this.previousStop;
    }

    @JsonProperty
    public StringComparator getOrdering() {
        return this.ordering;
    }

    @Override
    public Comparator getComparator(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
        return this.ordering;
    }

    @Override
    public TopNResultBuilder getResultBuilder(DateTime timestamp, DimensionSpec dimSpec, int threshold, Comparator comparator, List<AggregatorFactory> aggFactories, List<PostAggregator> postAggs) {
        return new TopNLexicographicResultBuilder(timestamp, dimSpec, threshold, this.previousStop, comparator, aggFactories);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] previousStopBytes = this.previousStop == null ? new byte[]{} : StringUtils.toUtf8(this.previousStop);
        byte[] orderingBytes = this.ordering.getCacheKey();
        int totalLen = 2 + previousStopBytes.length + orderingBytes.length;
        return ByteBuffer.allocate(totalLen).put((byte)4).put(previousStopBytes).put((byte)-1).put(orderingBytes).array();
    }

    @Override
    public <T> TopNMetricSpecBuilder<T> configureOptimizer(TopNMetricSpecBuilder<T> builder) {
        if (this.ordering.equals(StringComparators.LEXICOGRAPHIC)) {
            builder.skipTo(this.previousStop);
            builder.ignoreAfterThreshold();
        }
        return builder;
    }

    @Override
    public void initTopNAlgorithmSelector(TopNAlgorithmSelector selector) {
        selector.setAggregateAllMetrics(true);
    }

    @Override
    public String getMetricName(DimensionSpec dimSpec) {
        return dimSpec.getOutputName();
    }

    @Override
    public boolean canBeOptimizedUnordered() {
        return false;
    }

    public String toString() {
        return "DimensionTopNMetricSpec{previousStop='" + this.previousStop + '\'' + ", ordering=" + this.ordering + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionTopNMetricSpec that = (DimensionTopNMetricSpec)o;
        if (this.getPreviousStop() != null ? !this.getPreviousStop().equals(that.getPreviousStop()) : that.getPreviousStop() != null) {
            return false;
        }
        return this.getOrdering().equals(that.getOrdering());
    }

    public int hashCode() {
        int result = this.getPreviousStop() != null ? this.getPreviousStop().hashCode() : 0;
        result = 31 * result + this.getOrdering().hashCode();
        return result;
    }
}

