/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.timeboundary;

import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.BaseQuery;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class TimeBoundaryQuery
extends BaseQuery<Result<TimeBoundaryResultValue>> {
    private static final QuerySegmentSpec DEFAULT_SEGMENT_SPEC = new MultipleIntervalSegmentSpec(Intervals.ONLY_ETERNITY);
    public static final String MAX_TIME = "maxTime";
    public static final String MIN_TIME = "minTime";
    private static final byte CACHE_TYPE_ID = 0;
    private final DimFilter dimFilter;
    private final String bound;

    @JsonCreator
    public TimeBoundaryQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="bound") String bound, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec == null ? DEFAULT_SEGMENT_SPEC : querySegmentSpec, false, context);
        this.dimFilter = dimFilter;
        this.bound = bound == null ? "" : bound;
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    @JsonProperty(value="filter")
    public DimFilter getFilter() {
        return this.dimFilter;
    }

    @Override
    public String getType() {
        return "timeBoundary";
    }

    @JsonProperty
    public String getBound() {
        return this.bound;
    }

    public TimeBoundaryQuery withOverriddenContext(Map<String, Object> contextOverrides) {
        Map<String, Object> newContext = TimeBoundaryQuery.computeOverriddenContext(this.getContext(), contextOverrides);
        return Druids.TimeBoundaryQueryBuilder.copy(this).context(newContext).build();
    }

    public TimeBoundaryQuery withQuerySegmentSpec(QuerySegmentSpec spec) {
        return Druids.TimeBoundaryQueryBuilder.copy(this).intervals(spec).build();
    }

    @Override
    public Query<Result<TimeBoundaryResultValue>> withDataSource(DataSource dataSource) {
        return Druids.TimeBoundaryQueryBuilder.copy(this).dataSource(dataSource).build();
    }

    public byte[] getCacheKey() {
        byte[] filterBytes = this.dimFilter == null ? ByteArrays.EMPTY_ARRAY : this.dimFilter.getCacheKey();
        byte[] boundBytes = StringUtils.toUtf8(this.bound);
        int delimiter = -1;
        return ByteBuffer.allocate(2 + boundBytes.length + filterBytes.length).put((byte)0).put(boundBytes).put((byte)-1).put(filterBytes).array();
    }

    public Iterable<Result<TimeBoundaryResultValue>> buildResult(DateTime timestamp, DateTime min, DateTime max) {
        ArrayList<Result<TimeBoundaryResultValue>> results = new ArrayList<Result<TimeBoundaryResultValue>>();
        HashMap<String, DateTime> result = new HashMap<String, DateTime>();
        if (min != null) {
            result.put(MIN_TIME, min);
        }
        if (max != null) {
            result.put(MAX_TIME, max);
        }
        if (!result.isEmpty()) {
            results.add(new Result<TimeBoundaryResultValue>(timestamp, new TimeBoundaryResultValue(result)));
        }
        return results;
    }

    public Iterable<Result<TimeBoundaryResultValue>> mergeResults(List<Result<TimeBoundaryResultValue>> results) {
        DateTime maxTime;
        DateTime minTime;
        DateTime ts;
        if (results == null || results.isEmpty()) {
            return new ArrayList<Result<TimeBoundaryResultValue>>();
        }
        DateTime min = DateTimes.MAX;
        DateTime max = DateTimes.MIN;
        for (Result<TimeBoundaryResultValue> result : results) {
            DateTime currMaxTime;
            TimeBoundaryResultValue val = result.getValue();
            DateTime currMinTime = val.getMinTime();
            if (currMinTime != null && currMinTime.isBefore((ReadableInstant)min)) {
                min = currMinTime;
            }
            if ((currMaxTime = val.getMaxTime()) == null || !currMaxTime.isAfter((ReadableInstant)max)) continue;
            max = currMaxTime;
        }
        if (this.isMinTime()) {
            ts = min;
            minTime = min;
            maxTime = null;
        } else if (this.isMaxTime()) {
            ts = max;
            minTime = null;
            maxTime = max;
        } else {
            ts = min;
            minTime = min;
            maxTime = max;
        }
        return this.buildResult(ts, minTime, maxTime);
    }

    boolean isMinTime() {
        return this.bound.equalsIgnoreCase(MIN_TIME);
    }

    boolean isMaxTime() {
        return this.bound.equalsIgnoreCase(MAX_TIME);
    }

    public String toString() {
        return "TimeBoundaryQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", duration=" + this.getDuration() + ", bound=" + this.bound + ", dimFilter=" + this.dimFilter + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeBoundaryQuery that = (TimeBoundaryQuery)o;
        if (!this.bound.equals(that.bound)) {
            return false;
        }
        return !(this.dimFilter != null ? !this.dimFilter.equals(that.dimFilter) : that.dimFilter != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.bound.hashCode();
        result = 31 * result + (this.dimFilter != null ? this.dimFilter.hashCode() : 0);
        return result;
    }
}

