/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.search;

import java.util.List;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.search.CursorOnlyStrategy;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuery;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQueryDecisionHelper;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQueryExecutor;
import org.apache.hive.druid.org.apache.druid.query.search.SearchStrategy;
import org.apache.hive.druid.org.apache.druid.query.search.UseIndexesStrategy;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorBitmapIndexSelector;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumns;
import org.apache.hive.druid.org.apache.druid.segment.column.BitmapIndex;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnHolder;

public class AutoStrategy
extends SearchStrategy {
    public static final String NAME = "auto";
    private static final EmittingLogger log = new EmittingLogger(AutoStrategy.class);

    public static AutoStrategy of(SearchQuery query) {
        return new AutoStrategy(query);
    }

    private AutoStrategy(SearchQuery query) {
        super(query);
    }

    @Override
    public List<SearchQueryExecutor> getExecutionPlan(SearchQuery query, Segment segment) {
        QueryableIndex index = segment.asQueryableIndex();
        if (index != null) {
            ColumnSelectorBitmapIndexSelector selector = new ColumnSelectorBitmapIndexSelector(index.getBitmapFactoryForDimensions(), VirtualColumns.EMPTY, index);
            if (this.filter == null || this.filter.supportsSelectivityEstimation(index, selector)) {
                List<DimensionSpec> dimsToSearch = AutoStrategy.getDimsToSearch(index.getAvailableDimensions(), query.getDimensions());
                SearchQueryDecisionHelper helper = this.getDecisionHelper(index);
                double useIndexStrategyCost = helper.getBitmapIntersectCost() * (double)AutoStrategy.computeTotalCard(index, dimsToSearch);
                double cursorOnlyStrategyCost = (this.filter == null ? 1.0 : this.filter.estimateSelectivity(selector)) * (double)selector.getNumRows() * (double)dimsToSearch.size();
                log.debug("Use-index strategy cost: %f, cursor-only strategy cost: %f", useIndexStrategyCost, cursorOnlyStrategyCost);
                if (useIndexStrategyCost < cursorOnlyStrategyCost) {
                    log.debug("Use-index execution strategy is selected, query id [%s]", query.getId());
                    return UseIndexesStrategy.of(query).getExecutionPlan(query, segment);
                }
                log.debug("Cursor-only execution strategy is selected, query id [%s]", query.getId());
                return CursorOnlyStrategy.of(query).getExecutionPlan(query, segment);
            }
            log.debug("Filter doesn't support bitmap index. Fall back to cursor-only execution strategy, query id [%s]", query.getId());
            return CursorOnlyStrategy.of(query).getExecutionPlan(query, segment);
        }
        log.debug("Index doesn't exist. Fall back to cursor-only execution strategy, query id [%s]", query.getId());
        return CursorOnlyStrategy.of(query).getExecutionPlan(query, segment);
    }

    private static long computeTotalCard(QueryableIndex index, Iterable<DimensionSpec> dimensionSpecs) {
        long totalCard = 0L;
        for (DimensionSpec dimension : dimensionSpecs) {
            BitmapIndex bitmapIndex;
            ColumnHolder columnHolder = index.getColumnHolder(dimension.getDimension());
            if (columnHolder == null || (bitmapIndex = columnHolder.getBitmapIndex()) == null) continue;
            totalCard += (long)bitmapIndex.getCardinality();
        }
        return totalCard;
    }
}

