/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.HotLoopCallee;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;

public final class StringRuntimeShape {
    public static String of(HotLoopCallee hotLoopCallee) {
        return new Inspector().runtimeShapeOf(hotLoopCallee);
    }

    public static String of(HotLoopCallee ... hotLoopCallees) {
        return new Inspector().runtimeShapeOf(hotLoopCallees);
    }

    private StringRuntimeShape() {
    }

    private static class Inspector
    implements RuntimeShapeInspector {
        private final StringBuilder sb = new StringBuilder();
        private int indent = 0;

        private Inspector() {
        }

        String runtimeShapeOf(HotLoopCallee hotLoopCallee) {
            this.visit(hotLoopCallee);
            return this.sb.toString();
        }

        String runtimeShapeOf(HotLoopCallee[] hotLoopCallees) {
            for (HotLoopCallee hotLoopCallee : hotLoopCallees) {
                this.visit(hotLoopCallee);
                this.sb.append(",\n");
            }
            this.sb.setLength(this.sb.length() - 2);
            return this.sb.toString();
        }

        private void indent() {
            for (int i = 0; i < this.indent; ++i) {
                this.sb.append(' ');
            }
        }

        private void incrementIndent() {
            this.indent += 2;
        }

        private void decrementIndent() {
            this.indent -= 2;
        }

        private void visit(@Nullable Object value) {
            if (value == null) {
                this.sb.append("null");
                return;
            }
            this.sb.append(value.getClass().getName());
            if (value instanceof HotLoopCallee) {
                this.appendHotLoopCalleeShape((HotLoopCallee)value);
            } else if (value instanceof ByteBuffer) {
                this.appendByteBufferShape((ByteBuffer)value);
            }
        }

        private void appendHotLoopCalleeShape(HotLoopCallee value) {
            this.sb.append(" {\n");
            int lengthBeforeInspection = this.sb.length();
            this.incrementIndent();
            value.inspectRuntimeShape(this);
            this.decrementIndent();
            if (this.sb.length() == lengthBeforeInspection) {
                this.sb.setLength(lengthBeforeInspection - 3);
            } else {
                this.removeLastComma();
                this.indent();
                this.sb.append('}');
            }
        }

        private void appendByteBufferShape(ByteBuffer byteBuffer) {
            this.sb.append(" {order: ");
            this.sb.append(byteBuffer.order());
            this.sb.append('}');
        }

        private void removeLastComma() {
            assert (this.sb.charAt(this.sb.length() - 2) == ',' && this.sb.charAt(this.sb.length() - 1) == '\n');
            this.sb.setCharAt(this.sb.length() - 2, '\n');
            this.sb.setLength(this.sb.length() - 1);
        }

        @Override
        public void visit(String fieldName, @Nullable HotLoopCallee value) {
            this.visit(fieldName, (Object)value);
        }

        @Override
        public void visit(String fieldName, @Nullable Object value) {
            this.indent();
            this.sb.append(fieldName);
            this.sb.append(": ");
            this.visit(value);
            this.sb.append(",\n");
        }

        @Override
        public <T> void visit(String fieldName, T[] values) {
            this.indent();
            this.sb.append(fieldName);
            this.sb.append(": [\n");
            int lengthBeforeInspection = this.sb.length();
            this.incrementIndent();
            for (T value : values) {
                this.indent();
                this.visit(value);
                this.sb.append(",\n");
            }
            this.decrementIndent();
            if (this.sb.length() == lengthBeforeInspection) {
                this.sb.setCharAt(lengthBeforeInspection - 1, ']');
            } else {
                this.removeLastComma();
                this.indent();
                this.sb.append(']');
            }
            this.sb.append(",\n");
        }

        @Override
        public void visit(String flagName, boolean flagValue) {
            this.indent();
            this.sb.append(flagName);
            this.sb.append(": ");
            this.sb.append(flagValue);
            this.sb.append(",\n");
        }

        @Override
        public void visit(String key, String runtimeShape) {
            this.indent();
            this.sb.append(key);
            this.sb.append(": ");
            this.sb.append(runtimeShape);
            this.sb.append(",\n");
        }
    }
}

