/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.lookup;

import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupIntrospectHandler;

@JsonTypeName(value="map")
public class MapLookupExtractorFactory
implements LookupExtractorFactory {
    @JsonProperty
    private final Map<String, String> map;
    @JsonProperty
    private final boolean isOneToOne;
    private final MapLookupExtractor lookupExtractor;
    private final LookupIntrospectHandler lookupIntrospectHandler;

    @JsonCreator
    public MapLookupExtractorFactory(@JsonProperty(value="map") Map<String, String> map, @JsonProperty(value="isOneToOne") boolean isOneToOne) {
        this.map = Preconditions.checkNotNull(map, "map cannot be null");
        this.isOneToOne = isOneToOne;
        this.lookupExtractor = new MapLookupExtractor(map, isOneToOne);
        this.lookupIntrospectHandler = new MapLookupIntrospectionHandler(this.map);
    }

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public boolean replaces(@Nullable LookupExtractorFactory other) {
        return !this.equals(other);
    }

    @Override
    @Nullable
    public LookupIntrospectHandler getIntrospectHandler() {
        return this.lookupIntrospectHandler;
    }

    @Override
    public LookupExtractor get() {
        return this.lookupExtractor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapLookupExtractorFactory that = (MapLookupExtractorFactory)o;
        if (this.isOneToOne != that.isOneToOne) {
            return false;
        }
        return this.map.equals(that.map);
    }

    public int hashCode() {
        int result = this.map.hashCode();
        result = 31 * result + (this.isOneToOne ? 1 : 0);
        return result;
    }

    public static class MapLookupIntrospectionHandler
    implements LookupIntrospectHandler {
        private final Map<String, String> map;

        public MapLookupIntrospectionHandler(Map<String, String> map) {
            this.map = map;
        }

        @GET
        @Path(value="/keys")
        @Produces(value={"application/json"})
        public Response getKeys() {
            return Response.ok((Object)this.map.keySet().toString()).build();
        }

        @GET
        @Path(value="/values")
        @Produces(value={"application/json"})
        public Response getValues() {
            return Response.ok((Object)this.map.values().toString()).build();
        }

        @GET
        @Produces(value={"application/json"})
        public Response getMap() {
            return Response.ok(this.map).build();
        }
    }
}

