/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby.having;

import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.HavingSpecMetricComparator;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.HavingSpecUtil;

public class LessThanHavingSpec
implements HavingSpec {
    private final String aggregationName;
    private final Number value;
    private volatile Map<String, AggregatorFactory> aggregators;
    private volatile int columnNumber;

    public LessThanHavingSpec(@JsonProperty(value="aggregation") String aggName, @JsonProperty(value="value") Number value) {
        this.aggregationName = aggName;
        this.value = value;
    }

    @JsonProperty(value="aggregation")
    public String getAggregationName() {
        return this.aggregationName;
    }

    @JsonProperty(value="value")
    public Number getValue() {
        return this.value;
    }

    @Override
    public void setQuery(GroupByQuery query) {
        this.columnNumber = query.getResultRowPositionLookup().getInt(this.aggregationName);
        this.aggregators = HavingSpecUtil.computeAggregatorsMap(query.getAggregatorSpecs());
    }

    @Override
    public boolean eval(ResultRow row) {
        if (this.columnNumber < 0) {
            return false;
        }
        Object metricVal = row.get(this.columnNumber);
        if (metricVal == null || this.value == null) {
            return false;
        }
        return HavingSpecMetricComparator.compare(this.aggregationName, this.value, this.aggregators, metricVal) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LessThanHavingSpec that = (LessThanHavingSpec)o;
        if (this.value != null && that.value != null) {
            return Double.compare(this.value.doubleValue(), that.value.doubleValue()) == 0;
        }
        return this.value == null && that.value == null;
    }

    public int hashCode() {
        int result = this.aggregationName != null ? this.aggregationName.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LessThanHavingSpec");
        sb.append("{aggregationName='").append(this.aggregationName).append('\'');
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(6).appendString(this.aggregationName).appendByteArray(StringUtils.toUtf8(String.valueOf(this.value))).build();
    }
}

