/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby.having;

import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.org.apache.druid.data.input.Rows;
import org.apache.hive.druid.org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.IdentityExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.apache.hive.druid.org.apache.druid.query.groupby.having.HavingSpec;

public class DimensionSelectorHavingSpec
implements HavingSpec {
    private final String dimension;
    private final String value;
    private final ExtractionFn extractionFn;
    private volatile int columnNumber;

    @JsonCreator
    public DimensionSelectorHavingSpec(@JsonProperty(value="dimension") String dimName, @JsonProperty(value="value") String value, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        this.dimension = Preconditions.checkNotNull(dimName, "Must have attribute 'dimension'");
        this.value = value;
        this.extractionFn = extractionFn != null ? extractionFn : IdentityExtractionFn.getInstance();
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="dimension")
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Override
    public void setQuery(GroupByQuery query) {
        this.columnNumber = query.getResultRowPositionLookup().getInt(this.dimension);
    }

    @Override
    public boolean eval(ResultRow row) {
        if (this.columnNumber < 0) {
            return Strings.isNullOrEmpty(this.value);
        }
        List<String> dimRowValList = Rows.objectToStrings(row.get(this.columnNumber));
        if (dimRowValList == null || dimRowValList.isEmpty()) {
            return Strings.isNullOrEmpty(this.value);
        }
        for (String rowVal : dimRowValList) {
            String extracted = this.getExtractionFn().apply(rowVal);
            if (this.value != null && this.value.equals(extracted)) {
                return true;
            }
            if (extracted != null && !extracted.isEmpty()) continue;
            return Strings.isNullOrEmpty(this.value);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionSelectorHavingSpec that = (DimensionSelectorHavingSpec)o;
        return Objects.equals(this.dimension, that.dimension) && Objects.equals(this.value, that.value) && Objects.equals(this.extractionFn, that.extractionFn);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.value, this.extractionFn);
    }

    public String toString() {
        return "DimensionSelectorHavingSpec{dimension='" + this.dimension + '\'' + ", value='" + this.value + '\'' + ", extractionFn=" + this.extractionFn + '}';
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(2).appendString(this.dimension).appendString(this.value).appendByteArray(this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey()).build();
    }
}

