/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.vector;

import java.nio.ByteBuffer;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorValueSelector;

public class LongGroupByVectorColumnSelector
implements GroupByVectorColumnSelector {
    private final VectorValueSelector selector;

    LongGroupByVectorColumnSelector(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public int getGroupingKeySize() {
        return 2;
    }

    @Override
    public void writeKeys(int[] keySpace, int keySize, int keyOffset, int startRow, int endRow) {
        long[] vector = this.selector.getLongVector();
        int i = startRow;
        int j = keyOffset;
        while (i < endRow) {
            keySpace[j] = (int)(vector[i] >>> 32);
            keySpace[j + 1] = (int)(vector[i] & 0xFFFFFFFFL);
            ++i;
            j += keySize;
        }
    }

    @Override
    public void writeKeyToResultRow(ByteBuffer keyBuffer, int keyOffset, ResultRow resultRow, int resultRowPosition) {
        long value = keyBuffer.getLong(keyOffset * 4);
        resultRow.set(resultRowPosition, value);
    }
}

