/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.hive.druid.org.apache.druid.java.util.common.CloseableIterators;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.hive.druid.org.apache.druid.query.AbstractPrioritizedCallable;
import org.apache.hive.druid.org.apache.druid.query.QueryInterruptedException;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.Groupers;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.ParallelCombiner;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.SpillingGrouper;
import org.apache.hive.druid.org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;

public class ConcurrentGrouper<KeyType>
implements Grouper<KeyType> {
    private final List<SpillingGrouper<KeyType>> groupers;
    private final ThreadLocal<SpillingGrouper<KeyType>> threadLocalGrouper;
    private final AtomicInteger threadNumber = new AtomicInteger();
    private volatile boolean spilling = false;
    private volatile boolean closed = false;
    private final Supplier<ByteBuffer> bufferSupplier;
    private final ColumnSelectorFactory columnSelectorFactory;
    private final AggregatorFactory[] aggregatorFactories;
    private final int bufferGrouperMaxSize;
    private final float bufferGrouperMaxLoadFactor;
    private final int bufferGrouperInitialBuckets;
    private final LimitedTemporaryStorage temporaryStorage;
    private final ObjectMapper spillMapper;
    private final int concurrencyHint;
    private final Grouper.KeySerdeFactory<KeyType> keySerdeFactory;
    private final DefaultLimitSpec limitSpec;
    private final boolean sortHasNonGroupingFields;
    private final Comparator<Grouper.Entry<KeyType>> keyObjComparator;
    private final ListeningExecutorService executor;
    private final int priority;
    private final boolean hasQueryTimeout;
    private final long queryTimeoutAt;
    private final long maxDictionarySizeForCombiner;
    @Nullable
    private final ParallelCombiner<KeyType> parallelCombiner;
    private volatile boolean initialized = false;

    public ConcurrentGrouper(GroupByQueryConfig groupByQueryConfig, Supplier<ByteBuffer> bufferSupplier, @Nullable ReferenceCountingResourceHolder<ByteBuffer> combineBufferHolder, Grouper.KeySerdeFactory<KeyType> keySerdeFactory, Grouper.KeySerdeFactory<KeyType> combineKeySerdeFactory, ColumnSelectorFactory columnSelectorFactory, AggregatorFactory[] aggregatorFactories, LimitedTemporaryStorage temporaryStorage, ObjectMapper spillMapper, int concurrencyHint, DefaultLimitSpec limitSpec, boolean sortHasNonGroupingFields, ListeningExecutorService executor, int priority, boolean hasQueryTimeout, long queryTimeoutAt) {
        this(bufferSupplier, combineBufferHolder, keySerdeFactory, combineKeySerdeFactory, columnSelectorFactory, aggregatorFactories, groupByQueryConfig.getBufferGrouperMaxSize(), groupByQueryConfig.getBufferGrouperMaxLoadFactor(), groupByQueryConfig.getBufferGrouperInitialBuckets(), temporaryStorage, spillMapper, concurrencyHint, limitSpec, sortHasNonGroupingFields, executor, priority, hasQueryTimeout, queryTimeoutAt, groupByQueryConfig.getIntermediateCombineDegree(), groupByQueryConfig.getNumParallelCombineThreads());
    }

    ConcurrentGrouper(Supplier<ByteBuffer> bufferSupplier, @Nullable ReferenceCountingResourceHolder<ByteBuffer> combineBufferHolder, Grouper.KeySerdeFactory<KeyType> keySerdeFactory, Grouper.KeySerdeFactory<KeyType> combineKeySerdeFactory, ColumnSelectorFactory columnSelectorFactory, AggregatorFactory[] aggregatorFactories, int bufferGrouperMaxSize, float bufferGrouperMaxLoadFactor, int bufferGrouperInitialBuckets, LimitedTemporaryStorage temporaryStorage, ObjectMapper spillMapper, int concurrencyHint, DefaultLimitSpec limitSpec, boolean sortHasNonGroupingFields, ListeningExecutorService executor, int priority, boolean hasQueryTimeout, long queryTimeoutAt, int intermediateCombineDegree, int numParallelCombineThreads) {
        Preconditions.checkArgument(concurrencyHint > 0, "concurrencyHint > 0");
        Preconditions.checkArgument(concurrencyHint >= numParallelCombineThreads, "numParallelCombineThreads[%s] cannot larger than concurrencyHint[%s]", numParallelCombineThreads, concurrencyHint);
        this.groupers = new ArrayList<SpillingGrouper<KeyType>>(concurrencyHint);
        this.threadLocalGrouper = ThreadLocal.withInitial(() -> this.groupers.get(this.threadNumber.getAndIncrement()));
        this.bufferSupplier = bufferSupplier;
        this.columnSelectorFactory = columnSelectorFactory;
        this.aggregatorFactories = aggregatorFactories;
        this.bufferGrouperMaxSize = bufferGrouperMaxSize;
        this.bufferGrouperMaxLoadFactor = bufferGrouperMaxLoadFactor;
        this.bufferGrouperInitialBuckets = bufferGrouperInitialBuckets;
        this.temporaryStorage = temporaryStorage;
        this.spillMapper = spillMapper;
        this.concurrencyHint = concurrencyHint;
        this.keySerdeFactory = keySerdeFactory;
        this.limitSpec = limitSpec;
        this.sortHasNonGroupingFields = sortHasNonGroupingFields;
        this.keyObjComparator = keySerdeFactory.objectComparator(sortHasNonGroupingFields);
        this.executor = Preconditions.checkNotNull(executor);
        this.priority = priority;
        this.hasQueryTimeout = hasQueryTimeout;
        this.queryTimeoutAt = queryTimeoutAt;
        this.maxDictionarySizeForCombiner = combineKeySerdeFactory.getMaxDictionarySize();
        this.parallelCombiner = numParallelCombineThreads > 1 ? new ParallelCombiner<KeyType>(Preconditions.checkNotNull(combineBufferHolder, "combineBufferHolder"), this.getCombiningFactories(aggregatorFactories), combineKeySerdeFactory, executor, sortHasNonGroupingFields, Math.min(numParallelCombineThreads, concurrencyHint), priority, queryTimeoutAt, intermediateCombineDegree) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (!this.initialized) {
            Supplier<ByteBuffer> supplier = this.bufferSupplier;
            synchronized (supplier) {
                if (!this.initialized) {
                    ByteBuffer buffer = this.bufferSupplier.get();
                    int sliceSize = buffer.capacity() / this.concurrencyHint;
                    for (int i = 0; i < this.concurrencyHint; ++i) {
                        ByteBuffer slice = Groupers.getSlice(buffer, sliceSize, i);
                        SpillingGrouper<KeyType> grouper = new SpillingGrouper<KeyType>(Suppliers.ofInstance(slice), this.keySerdeFactory, this.columnSelectorFactory, this.aggregatorFactories, this.bufferGrouperMaxSize, this.bufferGrouperMaxLoadFactor, this.bufferGrouperInitialBuckets, this.temporaryStorage, this.spillMapper, false, this.limitSpec, this.sortHasNonGroupingFields, sliceSize);
                        grouper.init();
                        this.groupers.add(grouper);
                    }
                    this.initialized = true;
                }
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AggregateResult aggregate(KeyType key, int keyHash) {
        SpillingGrouper<KeyType> tlGrouper;
        SpillingGrouper<KeyType> spillingGrouper;
        if (!this.initialized) {
            throw new ISE("Grouper is not initialized", new Object[0]);
        }
        if (this.closed) {
            throw new ISE("Grouper is closed", new Object[0]);
        }
        if (!this.spilling) {
            SpillingGrouper<KeyType> hashBasedGrouper = this.groupers.get(this.grouperNumberForKeyHash(keyHash));
            spillingGrouper = hashBasedGrouper;
            synchronized (spillingGrouper) {
                if (!this.spilling) {
                    AggregateResult aggregateResult = hashBasedGrouper.aggregate(key, keyHash);
                    if (aggregateResult.isOk()) {
                        return AggregateResult.ok();
                    }
                    assert (aggregateResult.getCount() == 0);
                    this.spilling = true;
                }
            }
        }
        spillingGrouper = tlGrouper = this.threadLocalGrouper.get();
        synchronized (spillingGrouper) {
            tlGrouper.setSpillingAllowed(true);
            return tlGrouper.aggregate(key, keyHash);
        }
    }

    @Override
    public void reset() {
        if (!this.initialized) {
            throw new ISE("Grouper is not initialized", new Object[0]);
        }
        if (this.closed) {
            throw new ISE("Grouper is closed", new Object[0]);
        }
        this.groupers.forEach(Grouper::reset);
    }

    @Override
    public CloseableIterator<Grouper.Entry<KeyType>> iterator(boolean sorted) {
        List<String> dictionary;
        List<CloseableIterator<Grouper.Entry<KeyType>>> sortedIterators;
        if (!this.initialized) {
            throw new ISE("Grouper is not initialized", new Object[0]);
        }
        if (this.closed) {
            throw new ISE("Grouper is closed", new Object[0]);
        }
        List<CloseableIterator<Grouper.Entry<KeyType>>> list = sortedIterators = sorted && this.isParallelizable() ? this.parallelSortAndGetGroupersIterator() : this.getGroupersIterator(sorted);
        if (sorted && this.spilling && this.parallelCombiner != null && (dictionary = this.tryMergeDictionary()) != null) {
            return this.parallelCombiner.combine(sortedIterators, dictionary);
        }
        return sorted ? CloseableIterators.mergeSorted(sortedIterators, this.keyObjComparator) : CloseableIterators.concat(sortedIterators);
    }

    private boolean isParallelizable() {
        return this.concurrencyHint > 1;
    }

    private List<CloseableIterator<Grouper.Entry<KeyType>>> parallelSortAndGetGroupersIterator() {
        ListenableFuture future = Futures.allAsList(this.groupers.stream().map(grouper -> this.executor.submit(new AbstractPrioritizedCallable<CloseableIterator<Grouper.Entry<KeyType>>>(this.priority, (SpillingGrouper)grouper){
            final /* synthetic */ SpillingGrouper val$grouper;
            {
                this.val$grouper = spillingGrouper;
                super(priority);
            }

            @Override
            public CloseableIterator<Grouper.Entry<KeyType>> call() {
                return this.val$grouper.iterator(true);
            }
        })).collect(Collectors.toList()));
        try {
            long timeout = this.queryTimeoutAt - System.currentTimeMillis();
            return this.hasQueryTimeout ? (List)future.get(timeout, TimeUnit.MILLISECONDS) : (List)future.get();
        }
        catch (InterruptedException | TimeoutException e) {
            future.cancel(true);
            throw new QueryInterruptedException(e);
        }
        catch (CancellationException e) {
            throw new QueryInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private List<CloseableIterator<Grouper.Entry<KeyType>>> getGroupersIterator(boolean sorted) {
        return this.groupers.stream().map(grouper -> grouper.iterator(sorted)).collect(Collectors.toList());
    }

    @Nullable
    private List<String> tryMergeDictionary() {
        HashSet<String> mergedDictionary = new HashSet<String>();
        long totalDictionarySize = 0L;
        for (SpillingGrouper<KeyType> grouper : this.groupers) {
            List<String> dictionary = grouper.mergeAndGetDictionary();
            for (String key : dictionary) {
                if (!mergedDictionary.add(key) || (totalDictionarySize += RowBasedGrouperHelper.estimateStringKeySize(key)) <= this.maxDictionarySizeForCombiner) continue;
                return null;
            }
        }
        return ImmutableList.copyOf(mergedDictionary);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.groupers.forEach(Grouper::close);
        }
    }

    private int grouperNumberForKeyHash(int keyHash) {
        return keyHash % this.groupers.size();
    }

    private AggregatorFactory[] getCombiningFactories(AggregatorFactory[] aggregatorFactories) {
        AggregatorFactory[] combiningFactories = new AggregatorFactory[aggregatorFactories.length];
        Arrays.setAll(combiningFactories, i -> aggregatorFactories[i].getCombiningFactory());
        return combiningFactories;
    }
}

