/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae;

import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.org.apache.druid.java.util.common.CloseableIterators;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.AbstractBufferHashGrouper;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.ByteBufferHashTable;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.ByteBufferIntList;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.Groupers;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.VectorGrouper;

public class BufferHashGrouper<KeyType>
extends AbstractBufferHashGrouper<KeyType>
implements VectorGrouper {
    private static final int MIN_INITIAL_BUCKETS = 4;
    private static final int DEFAULT_INITIAL_BUCKETS = 1024;
    private static final float DEFAULT_MAX_LOAD_FACTOR = 0.7f;
    private boolean initialized = false;
    private final boolean useDefaultSorting;
    @Nullable
    private ByteBufferIntList offsetList;
    @Nullable
    private ByteBuffer vKeyBuffer = null;
    @Nullable
    private int[] vKeyHashCodes = null;
    @Nullable
    private int[] vAggregationPositions = null;
    @Nullable
    private int[] vAggregationRows = null;

    public BufferHashGrouper(Supplier<ByteBuffer> bufferSupplier, Grouper.KeySerde<KeyType> keySerde, AggregatorAdapters aggregators, int bufferGrouperMaxSize, float maxLoadFactor, int initialBuckets, boolean useDefaultSorting) {
        super(bufferSupplier, keySerde, aggregators, 4 + keySerde.keySize(), bufferGrouperMaxSize);
        this.maxLoadFactor = maxLoadFactor > 0.0f ? maxLoadFactor : 0.7f;
        int n = this.initialBuckets = initialBuckets > 0 ? Math.max(4, initialBuckets) : 1024;
        if (this.maxLoadFactor >= 1.0f) {
            throw new IAE("Invalid maxLoadFactor[%f], must be < 1.0", Float.valueOf(maxLoadFactor));
        }
        this.bucketSize = 4 + keySerde.keySize() + aggregators.spaceNeeded();
        this.useDefaultSorting = useDefaultSorting;
    }

    @Override
    public void init() {
        if (!this.initialized) {
            ByteBuffer buffer = (ByteBuffer)this.bufferSupplier.get();
            int hashTableSize = ByteBufferHashTable.calculateTableArenaSizeWithPerBucketAdditionalSize(buffer.capacity(), this.bucketSize, 4);
            this.hashTableBuffer = buffer.duplicate();
            this.hashTableBuffer.position(0);
            this.hashTableBuffer.limit(hashTableSize);
            this.hashTableBuffer = this.hashTableBuffer.slice();
            ByteBuffer offsetListBuffer = buffer.duplicate();
            offsetListBuffer.position(hashTableSize);
            offsetListBuffer.limit(buffer.capacity());
            offsetListBuffer = offsetListBuffer.slice();
            this.offsetList = new ByteBufferIntList(offsetListBuffer, offsetListBuffer.capacity() / 4);
            this.hashTable = new ByteBufferHashTable(this.maxLoadFactor, this.initialBuckets, this.bucketSize, this.hashTableBuffer, this.keySize, this.bufferGrouperMaxSize, new BufferGrouperBucketUpdateHandler());
            this.reset();
            this.initialized = true;
        }
    }

    @Override
    public void initVectorized(int maxVectorSize) {
        if (!ByteBuffer.class.equals(this.keySerde.keyClazz())) {
            throw new ISE("keyClazz[%s] must be ByteBuffer", this.keySerde.keyClazz());
        }
        if (this.keySize % 4 != 0) {
            throw new ISE("keySize[%s] must be a multiple of[%s]", this.keySize, 4);
        }
        this.init();
        this.vKeyBuffer = ByteBuffer.allocate(this.keySize);
        this.vKeyHashCodes = new int[maxVectorSize];
        this.vAggregationPositions = new int[maxVectorSize];
        this.vAggregationRows = new int[maxVectorSize];
    }

    @Override
    public AggregateResult aggregateVector(int[] keySpace, int startRow, int endRow) {
        int keyIntSize = this.keySize / 4;
        int numRows = endRow - startRow;
        int i = 0;
        int rowStart = 0;
        while (i < numRows) {
            this.vKeyHashCodes[i] = Groupers.hashIntArray(keySpace, rowStart, keyIntSize);
            ++i;
            rowStart += keyIntSize;
        }
        MutableInt aggregationStartRow = new MutableInt(startRow);
        MutableInt aggregationNumRows = new MutableInt(0);
        int rowNum = 0;
        int keySpacePosition = 0;
        while (rowNum < numRows) {
            this.vKeyBuffer.rewind();
            for (int i2 = 0; i2 < keyIntSize; ++i2) {
                this.vKeyBuffer.putInt(keySpace[keySpacePosition + i2]);
            }
            this.vKeyBuffer.rewind();
            int bucket = this.hashTable.findBucketWithAutoGrowth(this.vKeyBuffer, this.vKeyHashCodes[rowNum], () -> {
                if (aggregationNumRows.intValue() > 0) {
                    this.doAggregateVector(aggregationStartRow.intValue(), aggregationNumRows.intValue());
                    aggregationStartRow.setValue(aggregationStartRow.intValue() + aggregationNumRows.intValue());
                    aggregationNumRows.setValue(0);
                }
            });
            if (bucket < 0) {
                if (aggregationNumRows.intValue() > 0) {
                    this.doAggregateVector(aggregationStartRow.intValue(), aggregationNumRows.intValue());
                }
                return Groupers.hashTableFull(rowNum);
            }
            int bucketStartOffset = this.hashTable.getOffsetForBucket(bucket);
            boolean bucketWasUsed = this.hashTable.isBucketUsed(bucket);
            if (!bucketWasUsed) {
                this.hashTable.initializeNewBucketKey(bucket, this.vKeyBuffer, this.vKeyHashCodes[rowNum]);
                this.aggregators.init(this.hashTable.getTableBuffer(), bucketStartOffset + this.baseAggregatorOffset);
            }
            this.vAggregationPositions[aggregationNumRows.intValue()] = bucketStartOffset + 4 + this.keySize;
            aggregationNumRows.increment();
            ++rowNum;
            keySpacePosition += keyIntSize;
        }
        if (aggregationNumRows.intValue() > 0) {
            this.doAggregateVector(aggregationStartRow.intValue(), aggregationNumRows.intValue());
        }
        return AggregateResult.ok();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public ToIntFunction<KeyType> hashFunction() {
        return Groupers::hashObject;
    }

    @Override
    public void newBucketHook(int bucketOffset) {
    }

    @Override
    public boolean canSkipAggregate(int bucketOffset) {
        return false;
    }

    @Override
    public void afterAggregateHook(int bucketOffset) {
    }

    @Override
    public void reset() {
        this.offsetList.reset();
        this.hashTable.reset();
        this.keySerde.reset();
    }

    @Override
    public CloseableIterator<Grouper.Entry<ByteBuffer>> iterator() {
        return this.iterator(false);
    }

    @Override
    public CloseableIterator<Grouper.Entry<KeyType>> iterator(boolean sorted) {
        if (!this.initialized) {
            return CloseableIterators.withEmptyBaggage(Collections.emptyIterator());
        }
        if (sorted) {
            final AbstractList<Integer> wrappedOffsets = new AbstractList<Integer>(){

                @Override
                public Integer get(int index) {
                    return BufferHashGrouper.this.offsetList.get(index);
                }

                @Override
                public Integer set(int index, Integer element) {
                    Integer oldValue = this.get(index);
                    BufferHashGrouper.this.offsetList.set(index, element);
                    return oldValue;
                }

                @Override
                public int size() {
                    return BufferHashGrouper.this.hashTable.getSize();
                }
            };
            Grouper.BufferComparator comparator = this.useDefaultSorting ? this.keySerde.bufferComparator() : this.keySerde.bufferComparatorWithAggregators(this.aggregators.factories().toArray(new AggregatorFactory[0]), this.aggregators.aggregatorPositions());
            Collections.sort(wrappedOffsets, (lhs, rhs) -> {
                ByteBuffer tableBuffer = this.hashTable.getTableBuffer();
                return comparator.compare(tableBuffer, tableBuffer, lhs + 4, rhs + 4);
            });
            return new CloseableIterator<Grouper.Entry<KeyType>>(){
                int curr = 0;
                final int size = BufferHashGrouper.this.getSize();

                @Override
                public boolean hasNext() {
                    return this.curr < this.size;
                }

                @Override
                public Grouper.Entry<KeyType> next() {
                    if (this.curr >= this.size) {
                        throw new NoSuchElementException();
                    }
                    return BufferHashGrouper.this.bucketEntryForOffset((Integer)wrappedOffsets.get(this.curr++));
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void close() {
                }
            };
        }
        return new CloseableIterator<Grouper.Entry<KeyType>>(){
            int curr = 0;
            final int size = BufferHashGrouper.this.getSize();

            @Override
            public boolean hasNext() {
                return this.curr < this.size;
            }

            @Override
            public Grouper.Entry<KeyType> next() {
                if (this.curr >= this.size) {
                    throw new NoSuchElementException();
                }
                int offset = BufferHashGrouper.this.offsetList.get(this.curr);
                Grouper.Entry entry = BufferHashGrouper.this.bucketEntryForOffset(offset);
                ++this.curr;
                return entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }
        };
    }

    private void doAggregateVector(int startRow, int numRows) {
        this.aggregators.aggregateVector(this.hashTable.getTableBuffer(), numRows, this.vAggregationPositions, Groupers.writeAggregationRows(this.vAggregationRows, startRow, startRow + numRows));
    }

    private class BufferGrouperBucketUpdateHandler
    implements ByteBufferHashTable.BucketUpdateHandler {
        private BufferGrouperBucketUpdateHandler() {
        }

        @Override
        public void handleNewBucket(int bucketOffset) {
            BufferHashGrouper.this.offsetList.add(bucketOffset);
        }

        @Override
        public void handlePreTableSwap() {
            BufferHashGrouper.this.offsetList.reset();
        }

        @Override
        public void handleBucketMove(int oldBucketOffset, int newBucketOffset, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
            BufferHashGrouper.this.aggregators.relocate(oldBucketOffset + BufferHashGrouper.this.baseAggregatorOffset, newBucketOffset + BufferHashGrouper.this.baseAggregatorOffset, oldBuffer, newBuffer);
            BufferHashGrouper.this.offsetList.add(newBucketOffset);
        }
    }
}

