/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.Groupers;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.IntGrouper;
import org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae.VectorGrouper;

public class BufferArrayGrouper
implements VectorGrouper,
IntGrouper {
    private final Supplier<ByteBuffer> bufferSupplier;
    private final AggregatorAdapters aggregators;
    private final int cardinalityWithMissingValue;
    private final int recordSize;
    private boolean initialized = false;
    private ByteBuffer usedFlagBuffer;
    private ByteBuffer valBuffer;
    @Nullable
    private int[] vAggregationPositions = null;
    @Nullable
    private int[] vAggregationRows = null;

    static long requiredBufferCapacity(int cardinality, AggregatorFactory[] aggregatorFactories) {
        int cardinalityWithMissingValue = cardinality + 1;
        int recordSize = Arrays.stream(aggregatorFactories).mapToInt(AggregatorFactory::getMaxIntermediateSizeWithNulls).sum();
        return (long)BufferArrayGrouper.getUsedFlagBufferCapacity(cardinalityWithMissingValue) + (long)cardinalityWithMissingValue * (long)recordSize;
    }

    private static int getUsedFlagBufferCapacity(int cardinalityWithMissingValue) {
        return (cardinalityWithMissingValue + 8 - 1) / 8;
    }

    public BufferArrayGrouper(Supplier<ByteBuffer> bufferSupplier, AggregatorAdapters aggregators, int cardinality) {
        Preconditions.checkNotNull(aggregators, "aggregators");
        Preconditions.checkArgument(cardinality > 0, "Cardinality must a non-zero positive number");
        this.bufferSupplier = Preconditions.checkNotNull(bufferSupplier, "bufferSupplier");
        this.aggregators = aggregators;
        this.cardinalityWithMissingValue = cardinality + 1;
        this.recordSize = aggregators.spaceNeeded();
    }

    @Override
    public void init() {
        if (!this.initialized) {
            ByteBuffer buffer = this.bufferSupplier.get();
            int usedFlagBufferEnd = BufferArrayGrouper.getUsedFlagBufferCapacity(this.cardinalityWithMissingValue);
            if ((long)usedFlagBufferEnd + (long)this.cardinalityWithMissingValue * (long)this.recordSize > (long)buffer.capacity()) {
                throw new ISE("Records of size[%,d] and possible cardinality[%,d] exceeds the buffer capacity[%,d].", this.recordSize, this.cardinalityWithMissingValue, this.valBuffer.capacity());
            }
            buffer.position(0);
            buffer.limit(usedFlagBufferEnd);
            this.usedFlagBuffer = buffer.slice();
            buffer.position(usedFlagBufferEnd);
            buffer.limit(buffer.capacity());
            this.valBuffer = buffer.slice();
            this.reset();
            this.initialized = true;
        }
    }

    @Override
    public void initVectorized(int maxVectorSize) {
        this.init();
        this.vAggregationPositions = new int[maxVectorSize];
        this.vAggregationRows = new int[maxVectorSize];
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public AggregateResult aggregateKeyHash(int dimIndex) {
        Preconditions.checkArgument(dimIndex >= 0 && dimIndex < this.cardinalityWithMissingValue, "Invalid dimIndex[%s]", dimIndex);
        this.initializeSlotIfNeeded(dimIndex);
        this.aggregators.aggregateBuffered(this.valBuffer, dimIndex * this.recordSize);
        return AggregateResult.ok();
    }

    @Override
    public AggregateResult aggregateVector(int[] keySpace, int startRow, int endRow) {
        if (keySpace.length == 0) {
            boolean dimIndex = true;
            this.initializeSlotIfNeeded(1);
            this.aggregators.aggregateVector(this.valBuffer, 1 * this.recordSize, startRow, endRow);
        } else {
            int numRows = endRow - startRow;
            for (int i = 0; i < numRows; ++i) {
                int dimIndex = keySpace[i] + 1;
                if (dimIndex < 0 || dimIndex >= this.cardinalityWithMissingValue) {
                    throw new IAE("Invalid dimIndex[%s]", dimIndex);
                }
                this.vAggregationPositions[i] = dimIndex * this.recordSize;
                this.initializeSlotIfNeeded(dimIndex);
            }
            this.aggregators.aggregateVector(this.valBuffer, numRows, this.vAggregationPositions, Groupers.writeAggregationRows(this.vAggregationRows, startRow, endRow));
        }
        return AggregateResult.ok();
    }

    private void initializeSlotIfNeeded(int dimIndex) {
        int index = dimIndex / 8;
        int extraIndex = dimIndex % 8;
        int usedFlagByte = 1 << extraIndex;
        if ((this.usedFlagBuffer.get(index) & usedFlagByte) == 0) {
            this.usedFlagBuffer.put(index, (byte)(this.usedFlagBuffer.get(index) | 1 << extraIndex));
            this.aggregators.init(this.valBuffer, dimIndex * this.recordSize);
        }
    }

    private boolean isUsedSlot(int dimIndex) {
        int index = dimIndex / 8;
        int extraIndex = dimIndex % 8;
        int usedFlagByte = 1 << extraIndex;
        return (this.usedFlagBuffer.get(index) & usedFlagByte) != 0;
    }

    @Override
    public void reset() {
        int i;
        int usedFlagBufferCapacity = this.usedFlagBuffer.capacity();
        int n = usedFlagBufferCapacity / 8 * 8;
        for (i = 0; i < n; i += 8) {
            this.usedFlagBuffer.putLong(i, 0L);
        }
        for (i = n; i < usedFlagBufferCapacity; ++i) {
            this.usedFlagBuffer.put(i, (byte)0);
        }
    }

    @Override
    public IntGrouper.IntGrouperHashFunction hashFunction() {
        return key -> key + 1;
    }

    @Override
    public void close() {
        this.aggregators.close();
    }

    @Override
    public CloseableIterator<Grouper.Entry<ByteBuffer>> iterator() {
        final CloseableIterator<Grouper.Entry<Integer>> iterator = this.iterator(false);
        final ByteBuffer keyBuffer = ByteBuffer.allocate(4);
        return new CloseableIterator<Grouper.Entry<ByteBuffer>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Grouper.Entry<ByteBuffer> next() {
                Grouper.Entry integerEntry = (Grouper.Entry)iterator.next();
                keyBuffer.putInt(0, (Integer)integerEntry.getKey());
                return new Grouper.Entry<ByteBuffer>(keyBuffer, integerEntry.getValues());
            }

            @Override
            public void close() throws IOException {
                iterator.close();
            }
        };
    }

    @Override
    public CloseableIterator<Grouper.Entry<Integer>> iterator(boolean sorted) {
        if (sorted) {
            throw new UnsupportedOperationException("sorted iterator is not supported yet");
        }
        return new CloseableIterator<Grouper.Entry<Integer>>(){
            private int next = this.findNext(-1);

            @Override
            public boolean hasNext() {
                return this.next >= 0;
            }

            @Override
            public Grouper.Entry<Integer> next() {
                if (this.next < 0) {
                    throw new NoSuchElementException();
                }
                int current = this.next;
                this.next = this.findNext(current);
                Object[] values = new Object[BufferArrayGrouper.this.aggregators.size()];
                int recordOffset = current * BufferArrayGrouper.this.recordSize;
                for (int i = 0; i < BufferArrayGrouper.this.aggregators.size(); ++i) {
                    values[i] = BufferArrayGrouper.this.aggregators.get(BufferArrayGrouper.this.valBuffer, recordOffset, i);
                }
                return new Grouper.Entry<Integer>(current - 1, values);
            }

            @Override
            public void close() {
            }

            private int findNext(int current) {
                for (int i = current + 1; i < BufferArrayGrouper.this.cardinalityWithMissingValue; ++i) {
                    if (!BufferArrayGrouper.this.isUsedSlot(i)) continue;
                    return i;
                }
                return -1;
            }
        };
    }
}

