/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.groupby.epinephelinae;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;

public class AggregateResult {
    private static final AggregateResult OK = new AggregateResult(0, null);
    private final int count;
    @Nullable
    private final String reason;

    public static AggregateResult ok() {
        return OK;
    }

    public static AggregateResult partial(int count, String reason) {
        return new AggregateResult(count, Preconditions.checkNotNull(reason, "reason"));
    }

    private AggregateResult(int count, @Nullable String reason) {
        Preconditions.checkArgument(count >= 0, "count >= 0");
        this.count = count;
        this.reason = reason;
    }

    public boolean isOk() {
        return this.reason == null;
    }

    public int getCount() {
        if (this.isOk()) {
            throw new ISE("Cannot call getCount when isOk = true", new Object[0]);
        }
        return this.count;
    }

    @Nullable
    public String getReason() {
        if (this.isOk()) {
            throw new ISE("Cannot call getReason when isOk = true", new Object[0]);
        }
        return this.reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateResult that = (AggregateResult)o;
        return this.count == that.count && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.reason);
    }

    public String toString() {
        return "AggregateResult{count=" + this.count + ", reason='" + this.reason + '\'' + '}';
    }
}

