/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.filter;

import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.org.apache.druid.math.expr.Parser;
import org.apache.hive.druid.org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.query.filter.FilterTuning;
import org.apache.hive.druid.org.apache.druid.segment.filter.ExpressionFilter;

public class ExpressionDimFilter
implements DimFilter {
    private final String expression;
    private final Supplier<Expr> parsed;
    @Nullable
    private final FilterTuning filterTuning;

    @JsonCreator
    public ExpressionDimFilter(@JsonProperty(value="expression") String expression, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning, @JacksonInject ExprMacroTable macroTable) {
        this.expression = expression;
        this.filterTuning = filterTuning;
        this.parsed = Suppliers.memoize(() -> Parser.parse(expression, macroTable));
    }

    @VisibleForTesting
    public ExpressionDimFilter(String expression, ExprMacroTable macroTable) {
        this(expression, null, macroTable);
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new ExpressionFilter(this.parsed, this.filterTuning);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return this.parsed.get().analyzeInputs().getRequiredBindings();
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(14).appendString(this.expression).build();
    }

    public String toString() {
        return "ExpressionDimFilter{expression='" + this.expression + '\'' + ", filterTuning=" + this.filterTuning + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionDimFilter that = (ExpressionDimFilter)o;
        return this.expression.equals(that.expression) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.filterTuning);
    }
}

