/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.filter;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.segment.filter.ColumnComparisonFilter;

public class ColumnComparisonDimFilter
implements DimFilter {
    private static final Joiner COMMA_JOINER = Joiner.on(", ");
    private final List<DimensionSpec> dimensions;

    @JsonCreator
    public ColumnComparisonDimFilter(@JsonProperty(value="dimensions") List<DimensionSpec> dimensions) {
        this.dimensions = Preconditions.checkNotNull(dimensions, "dimensions");
        Preconditions.checkArgument(dimensions.size() >= 2, "dimensions must have a least 2 dimensions");
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(13).appendCacheablesIgnoringOrder(this.dimensions).build();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new ColumnComparisonFilter(this.dimensions);
    }

    @JsonProperty
    public List<DimensionSpec> getDimensions() {
        return this.dimensions;
    }

    public String toString() {
        return "ColumnComparisonDimFilter{dimensions=[" + COMMA_JOINER.join(this.dimensions) + "]}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnComparisonDimFilter that = (ColumnComparisonDimFilter)o;
        return this.dimensions.equals(that.dimensions);
    }

    public int hashCode() {
        return Objects.hash(this.dimensions);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return this.dimensions.stream().map(DimensionSpec::getDimension).collect(Collectors.toSet());
    }
}

