/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.filter;

import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.com.google.common.hash.HashCode;
import org.apache.hive.druid.org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.filter.BloomKFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.BloomKFilterHolder;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilterUtils;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.query.filter.FilterTuning;
import org.apache.hive.druid.org.apache.druid.segment.filter.DimensionPredicateFilter;

public class BloomDimFilter
implements DimFilter {
    private final String dimension;
    private final BloomKFilter bloomKFilter;
    private final HashCode hash;
    @Nullable
    private final ExtractionFn extractionFn;
    @Nullable
    private final FilterTuning filterTuning;

    @JsonCreator
    public BloomDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="bloomKFilter") BloomKFilterHolder bloomKFilterHolder, @JsonProperty(value="extractionFn") @Nullable ExtractionFn extractionFn, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        Preconditions.checkArgument(dimension != null, "dimension must not be null");
        Preconditions.checkNotNull(bloomKFilterHolder);
        this.dimension = dimension;
        this.bloomKFilter = bloomKFilterHolder.getFilter();
        this.hash = bloomKFilterHolder.getFilterHash();
        this.extractionFn = extractionFn;
        this.filterTuning = filterTuning;
    }

    @VisibleForTesting
    public BloomDimFilter(String dimension, BloomKFilterHolder bloomKFilterHolder, @Nullable ExtractionFn extractionFn) {
        this(dimension, bloomKFilterHolder, extractionFn, null);
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(DimFilterUtils.BLOOM_DIM_FILTER_CACHE_ID).appendString(this.dimension).appendByte((byte)-1).appendByteArray(this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey()).appendByte((byte)-1).appendByteArray(this.hash.asBytes()).build();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new DimensionPredicateFilter(this.dimension, new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                return str -> {
                    if (str == null) {
                        return BloomDimFilter.this.bloomKFilter.testBytes(null, 0, 0);
                    }
                    return BloomDimFilter.this.bloomKFilter.testString((String)str);
                };
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        return BloomDimFilter.this.bloomKFilter.testLong(input);
                    }

                    @Override
                    public boolean applyNull() {
                        return BloomDimFilter.this.bloomKFilter.testBytes(null, 0, 0);
                    }
                };
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                return new DruidFloatPredicate(){

                    @Override
                    public boolean applyFloat(float input) {
                        return BloomDimFilter.this.bloomKFilter.testFloat(input);
                    }

                    @Override
                    public boolean applyNull() {
                        return BloomDimFilter.this.bloomKFilter.testBytes(null, 0, 0);
                    }
                };
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                return new DruidDoublePredicate(){

                    @Override
                    public boolean applyDouble(double input) {
                        return BloomDimFilter.this.bloomKFilter.testDouble(input);
                    }

                    @Override
                    public boolean applyNull() {
                        return BloomDimFilter.this.bloomKFilter.testBytes(null, 0, 0);
                    }
                };
            }
        }, this.extractionFn, this.filterTuning);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public BloomKFilter getBloomKFilter() {
        return this.bloomKFilter;
    }

    @Nullable
    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of(this.dimension);
    }

    public String toString() {
        return new DimFilter.DimFilterToStringBuilder().appendDimension(this.dimension, this.extractionFn).appendEquals(this.hash.toString()).appendFilterTuning(this.filterTuning).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BloomDimFilter that = (BloomDimFilter)o;
        return this.dimension.equals(that.dimension) && this.hash.equals(that.hash) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.hash, this.extractionFn, this.filterTuning);
    }
}

