/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.org.apache.druid.query.expression.ExprUtils;

public abstract class TrimExprMacro
implements ExprMacroTable.ExprMacro {
    private static final char[] EMPTY_CHARS = new char[0];
    private static final char[] DEFAULT_CHARS = new char[]{' '};
    private final TrimMode mode;
    private final String name;

    public TrimExprMacro(String name, TrimMode mode) {
        this.name = name;
        this.mode = mode;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Expr apply(List<Expr> args) {
        if (args.size() < 1 || args.size() > 2) {
            throw new IAE("Function[%s] must have 1 or 2 arguments", this.name());
        }
        if (args.size() == 1) {
            return new TrimStaticCharsExpr(this.mode, args.get(0), DEFAULT_CHARS);
        }
        Expr charsArg = args.get(1);
        if (charsArg.isLiteral()) {
            String charsString = charsArg.eval(ExprUtils.nilBindings()).asString();
            char[] chars = charsString == null ? EMPTY_CHARS : charsString.toCharArray();
            return new TrimStaticCharsExpr(this.mode, args.get(0), chars);
        }
        return new TrimDynamicCharsExpr(this.mode, args.get(0), args.get(1));
    }

    private static boolean arrayContains(char[] array, char c) {
        for (char arrayChar : array) {
            if (arrayChar != c) continue;
            return true;
        }
        return false;
    }

    private static boolean stringContains(String string, char c) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public static class RightTrimExprMacro
    extends TrimExprMacro {
        public RightTrimExprMacro() {
            super("rtrim", TrimMode.RIGHT);
        }
    }

    public static class LeftTrimExprMacro
    extends TrimExprMacro {
        public LeftTrimExprMacro() {
            super("ltrim", TrimMode.LEFT);
        }
    }

    public static class BothTrimExprMacro
    extends TrimExprMacro {
        public BothTrimExprMacro() {
            super("trim", TrimMode.BOTH);
        }
    }

    private static class TrimDynamicCharsExpr
    implements Expr {
        private final TrimMode mode;
        private final Expr stringExpr;
        private final Expr charsExpr;

        public TrimDynamicCharsExpr(TrimMode mode, Expr stringExpr, Expr charsExpr) {
            this.mode = mode;
            this.stringExpr = stringExpr;
            this.charsExpr = charsExpr;
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            int start;
            ExprEval stringEval = this.stringExpr.eval(bindings);
            if (stringEval.value() == null) {
                return stringEval;
            }
            ExprEval charsEval = this.charsExpr.eval(bindings);
            if (charsEval.value() == null) {
                return stringEval;
            }
            String s = stringEval.asString();
            String chars = charsEval.asString();
            int end = s.length();
            if (this.mode.isLeft()) {
                for (start = 0; start < s.length() && TrimExprMacro.stringContains(chars, s.charAt(start)); ++start) {
                }
            }
            if (this.mode.isRight()) {
                while (end > start && TrimExprMacro.stringContains(chars, s.charAt(end - 1))) {
                    --end;
                }
            }
            if (start == 0 && end == s.length()) {
                return stringEval;
            }
            return ExprEval.of(s.substring(start, end));
        }

        @Override
        public void visit(Expr.Visitor visitor) {
            this.stringExpr.visit(visitor);
            this.charsExpr.visit(visitor);
            visitor.visit(this);
        }

        @Override
        public Expr visit(Expr.Shuttle shuttle) {
            Expr newStringExpr = this.stringExpr.visit(shuttle);
            Expr newCharsExpr = this.charsExpr.visit(shuttle);
            return shuttle.visit(new TrimDynamicCharsExpr(this.mode, newStringExpr, newCharsExpr));
        }

        @Override
        public Expr.BindingDetails analyzeInputs() {
            return this.stringExpr.analyzeInputs().with(this.charsExpr).withScalarArguments(ImmutableSet.of(this.stringExpr, this.charsExpr));
        }
    }

    private static class TrimStaticCharsExpr
    extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
        private final TrimMode mode;
        private final char[] chars;

        public TrimStaticCharsExpr(TrimMode mode, Expr stringExpr, char[] chars) {
            super(stringExpr);
            this.mode = mode;
            this.chars = chars;
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            int start;
            ExprEval stringEval = this.arg.eval(bindings);
            if (this.chars.length == 0 || stringEval.value() == null) {
                return stringEval;
            }
            String s = stringEval.asString();
            int end = s.length();
            if (this.mode.isLeft()) {
                for (start = 0; start < s.length() && TrimExprMacro.arrayContains(this.chars, s.charAt(start)); ++start) {
                }
            }
            if (this.mode.isRight()) {
                while (end > start && TrimExprMacro.arrayContains(this.chars, s.charAt(end - 1))) {
                    --end;
                }
            }
            if (start == 0 && end == s.length()) {
                return stringEval;
            }
            return ExprEval.of(s.substring(start, end));
        }

        @Override
        public Expr visit(Expr.Shuttle shuttle) {
            Expr newStringExpr = this.arg.visit(shuttle);
            return shuttle.visit(new TrimStaticCharsExpr(this.mode, newStringExpr, this.chars));
        }
    }

    static enum TrimMode {
        BOTH(true, true),
        LEFT(true, false),
        RIGHT(false, true);

        private final boolean left;
        private final boolean right;

        private TrimMode(boolean left, boolean right) {
            this.left = left;
            this.right = right;
        }

        public boolean isLeft() {
            return this.left;
        }

        public boolean isRight() {
            return this.right;
        }
    }
}

