/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.expression;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.org.apache.druid.query.expression.ExprUtils;

public class TimestampFloorExprMacro
implements ExprMacroTable.ExprMacro {
    @Override
    public String name() {
        return "timestamp_floor";
    }

    @Override
    public Expr apply(List<Expr> args) {
        if (args.size() < 2 || args.size() > 4) {
            throw new IAE("Function[%s] must have 2 to 4 arguments", this.name());
        }
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampFloorExpr(args);
        }
        return new TimestampFloorDynamicExpr(args);
    }

    private static PeriodGranularity computeGranularity(List<Expr> args, Expr.ObjectBinding bindings) {
        return ExprUtils.toPeriodGranularity(args.get(1), args.size() > 2 ? args.get(2) : null, args.size() > 3 ? args.get(3) : null, bindings);
    }

    public static class TimestampFloorDynamicExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        TimestampFloorDynamicExpr(List<Expr> args) {
            super(args);
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            PeriodGranularity granularity = TimestampFloorExprMacro.computeGranularity(this.args, bindings);
            return ExprEval.of(granularity.bucketStart(DateTimes.utc(((Expr)this.args.get(0)).eval(bindings).asLong())).getMillis());
        }

        @Override
        public Expr visit(Expr.Shuttle shuttle) {
            List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
            return shuttle.visit(new TimestampFloorDynamicExpr(newArgs));
        }
    }

    public static class TimestampFloorExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final PeriodGranularity granularity;

        TimestampFloorExpr(List<Expr> args) {
            super(args);
            this.granularity = TimestampFloorExprMacro.computeGranularity(args, ExprUtils.nilBindings());
        }

        public Expr getArg() {
            return (Expr)this.args.get(0);
        }

        public PeriodGranularity getGranularity() {
            return this.granularity;
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            ExprEval eval = ((Expr)this.args.get(0)).eval(bindings);
            if (eval.isNumericNull()) {
                return ExprEval.of(null);
            }
            return ExprEval.of(this.granularity.bucketStart(DateTimes.utc(eval.asLong())).getMillis());
        }

        @Override
        public Expr visit(Expr.Shuttle shuttle) {
            List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
            return shuttle.visit(new TimestampFloorExpr(newArgs));
        }
    }
}

