/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.org.apache.druid.query.expression.ExprUtils;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class TimestampExtractExprMacro
implements ExprMacroTable.ExprMacro {
    @Override
    public String name() {
        return "timestamp_extract";
    }

    @Override
    public Expr apply(List<Expr> args) {
        if (args.size() < 2 || args.size() > 3) {
            throw new IAE("Function[%s] must have 2 to 3 arguments", this.name());
        }
        if (!args.get(1).isLiteral() || args.get(1).getLiteralValue() == null) {
            throw new IAE("Function[%s] unit arg must be literal", this.name());
        }
        if (args.size() > 2 && !args.get(2).isLiteral()) {
            throw new IAE("Function[%s] timezone arg must be literal", this.name());
        }
        Expr arg = args.get(0);
        Unit unit = Unit.valueOf(StringUtils.toUpperCase((String)args.get(1).getLiteralValue()));
        DateTimeZone timeZone = args.size() > 2 ? ExprUtils.toTimeZone(args.get(2)) : DateTimeZone.UTC;
        ISOChronology chronology = ISOChronology.getInstance((DateTimeZone)timeZone);
        class TimestampExtractExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            final /* synthetic */ ISOChronology val$chronology;
            final /* synthetic */ Unit val$unit;

            TimestampExtractExpr(Expr arg) {
                this.val$chronology = iSOChronology;
                this.val$unit = unit;
                super(arg);
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                Object val = this.arg.eval(bindings).value();
                if (val == null) {
                    return ExprEval.of(null);
                }
                DateTime dateTime = new DateTime(val, (Chronology)this.val$chronology);
                long epoch = dateTime.getMillis() / 1000L;
                switch (this.val$unit) {
                    case EPOCH: {
                        return ExprEval.of(epoch);
                    }
                    case MICROSECOND: {
                        return ExprEval.of(epoch / 1000L);
                    }
                    case MILLISECOND: {
                        return ExprEval.of(dateTime.millisOfSecond().get());
                    }
                    case SECOND: {
                        return ExprEval.of(dateTime.secondOfMinute().get());
                    }
                    case MINUTE: {
                        return ExprEval.of(dateTime.minuteOfHour().get());
                    }
                    case HOUR: {
                        return ExprEval.of(dateTime.hourOfDay().get());
                    }
                    case DAY: {
                        return ExprEval.of(dateTime.dayOfMonth().get());
                    }
                    case DOW: {
                        return ExprEval.of(dateTime.dayOfWeek().get());
                    }
                    case ISODOW: {
                        return ExprEval.of(dateTime.dayOfWeek().get());
                    }
                    case DOY: {
                        return ExprEval.of(dateTime.dayOfYear().get());
                    }
                    case WEEK: {
                        return ExprEval.of(dateTime.weekOfWeekyear().get());
                    }
                    case MONTH: {
                        return ExprEval.of(dateTime.monthOfYear().get());
                    }
                    case QUARTER: {
                        return ExprEval.of((dateTime.monthOfYear().get() - 1) / 3 + 1);
                    }
                    case YEAR: {
                        return ExprEval.of(dateTime.year().get());
                    }
                    case ISOYEAR: {
                        return ExprEval.of(dateTime.year().get());
                    }
                    case DECADE: {
                        return ExprEval.of(Math.floor(dateTime.year().get() / 10));
                    }
                    case CENTURY: {
                        return ExprEval.of(dateTime.centuryOfEra().get() + 1);
                    }
                    case MILLENNIUM: {
                        return ExprEval.of(Math.round(Math.ceil(dateTime.year().get() / 1000)));
                    }
                }
                throw new ISE("Unhandled unit[%s]", new Object[]{this.val$unit});
            }

            @Override
            public Expr visit(Expr.Shuttle shuttle) {
                Expr newArg = this.arg.visit(shuttle);
                return shuttle.visit(new TimestampExtractExpr(newArg));
            }
        }
        return new TimestampExtractExpr(arg);
    }

    public static enum Unit {
        EPOCH,
        MICROSECOND,
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        DOW,
        ISODOW,
        DOY,
        WEEK,
        MONTH,
        QUARTER,
        YEAR,
        ISOYEAR,
        DECADE,
        CENTURY,
        MILLENNIUM;

    }
}

