/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.expression;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprMacroTable;

public class RegexpExtractExprMacro
implements ExprMacroTable.ExprMacro {
    @Override
    public String name() {
        return "regexp_extract";
    }

    @Override
    public Expr apply(List<Expr> args) {
        Expr indexExpr;
        if (args.size() < 2 || args.size() > 3) {
            throw new IAE("Function[%s] must have 2 to 3 arguments", this.name());
        }
        Expr arg = args.get(0);
        Expr patternExpr = args.get(1);
        Expr expr = indexExpr = args.size() > 2 ? args.get(2) : null;
        if (!patternExpr.isLiteral() || indexExpr != null && !indexExpr.isLiteral()) {
            throw new IAE("Function[%s] pattern and index must be literals", this.name());
        }
        Pattern pattern = Pattern.compile(String.valueOf(patternExpr.getLiteralValue()));
        int index = indexExpr == null ? 0 : ((Number)indexExpr.getLiteralValue()).intValue();
        class RegexpExtractExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            final /* synthetic */ Pattern val$pattern;
            final /* synthetic */ int val$index;

            RegexpExtractExpr(Expr arg) {
                this.val$pattern = pattern;
                this.val$index = n;
                super(arg);
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                String s = this.arg.eval(bindings).asString();
                Matcher matcher = this.val$pattern.matcher(NullHandling.nullToEmptyIfNeeded(s));
                String retVal = matcher.find() ? matcher.group(this.val$index) : null;
                return ExprEval.of(NullHandling.emptyToNullIfNeeded(retVal));
            }

            @Override
            public Expr visit(Expr.Shuttle shuttle) {
                Expr newArg = this.arg.visit(shuttle);
                return shuttle.visit(new RegexpExtractExpr(newArg));
            }
        }
        return new RegexpExtractExpr(arg);
    }
}

