/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.expression;

import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.chrono.ISOChronology;

public class ExprUtils {
    private static final Expr.ObjectBinding NIL_BINDINGS = name -> null;

    public static Expr.ObjectBinding nilBindings() {
        return NIL_BINDINGS;
    }

    static DateTimeZone toTimeZone(Expr timeZoneArg) {
        if (!timeZoneArg.isLiteral()) {
            throw new IAE("Time zone must be a literal", new Object[0]);
        }
        Object literalValue = timeZoneArg.getLiteralValue();
        return literalValue == null ? DateTimeZone.UTC : DateTimes.inferTzFromString((String)literalValue);
    }

    static PeriodGranularity toPeriodGranularity(Expr periodArg, @Nullable Expr originArg, @Nullable Expr timeZoneArg, Expr.ObjectBinding bindings) {
        Object origin;
        DateTimeZone timeZone;
        Period period = new Period((Object)periodArg.eval(bindings).asString());
        if (timeZoneArg == null) {
            timeZone = null;
        } else {
            String value = timeZoneArg.eval(bindings).asString();
            DateTimeZone dateTimeZone = timeZone = value != null ? DateTimes.inferTzFromString(value) : null;
        }
        if (originArg == null) {
            origin = null;
        } else {
            ISOChronology chronology = timeZone == null ? ISOChronology.getInstanceUTC() : ISOChronology.getInstance(timeZone);
            Object value = originArg.eval(bindings).value();
            origin = value instanceof String && NullHandling.isNullOrEquivalent((String)value) ? null : (value != null ? new DateTime(value, (Chronology)chronology) : null);
        }
        return new PeriodGranularity(period, (DateTime)origin, timeZone);
    }

    static String createErrMsg(String functionName, String msg) {
        String prefix = "Function[" + functionName + "] ";
        return prefix + msg;
    }

    static void checkLiteralArgument(String functionName, Expr arg, String argName) {
        Preconditions.checkArgument(arg.isLiteral(), ExprUtils.createErrMsg(functionName, argName + " arg must be a literal"));
    }
}

