/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.mean;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.collect.Utils;
import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.mean.DoubleMeanAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.mean.DoubleMeanBufferAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.mean.DoubleMeanHolder;
import org.apache.hive.druid.org.apache.druid.query.aggregation.mean.DoubleMeanVectorAggregator;
import org.apache.hive.druid.org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class DoubleMeanAggregatorFactory
extends AggregatorFactory {
    private final String name;
    private final String fieldName;

    @JsonCreator
    public DoubleMeanAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        this.name = Preconditions.checkNotNull(name, "null name");
        this.fieldName = Preconditions.checkNotNull(fieldName, "null fieldName");
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    @Override
    public String getTypeName() {
        return "doubleMean";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 128;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new DoubleMeanAggregator(metricFactory.makeColumnValueSelector(this.fieldName));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new DoubleMeanBufferAggregator(metricFactory.makeColumnValueSelector(this.fieldName));
    }

    @Override
    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        return new DoubleMeanVectorAggregator(selectorFactory.makeValueSelector(this.fieldName));
    }

    @Override
    public boolean canVectorize() {
        return true;
    }

    @Override
    public Comparator getComparator() {
        return DoubleMeanHolder.COMPARATOR;
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (lhs instanceof DoubleMeanHolder && rhs instanceof DoubleMeanHolder) {
            return ((DoubleMeanHolder)lhs).update((DoubleMeanHolder)rhs);
        }
        throw new IAE("lhs[%s] or rhs[%s] not of type [%s]", Utils.safeObjectClassGetName(lhs), Utils.safeObjectClassGetName(rhs), DoubleMeanHolder.class.getName());
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new DoubleMeanAggregatorFactory(this.name, this.name);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new DoubleMeanAggregatorFactory(this.fieldName, this.fieldName));
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof String) {
            return DoubleMeanHolder.fromBytes(StringUtils.decodeBase64(StringUtils.toUtf8((String)object)));
        }
        if (object instanceof DoubleMeanHolder) {
            return object;
        }
        throw new IAE("Unknown object type [%s]", Utils.safeObjectClassGetName(object));
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        if (object instanceof DoubleMeanHolder) {
            return ((DoubleMeanHolder)object).mean();
        }
        if (object == null) {
            return null;
        }
        throw new IAE("Unknown object type [%s]", object.getClass().getName());
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(65).appendString(this.name).appendString(this.fieldName).build();
    }
}

