/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import org.apache.hive.druid.org.apache.druid.collections.SerializablePair;
import org.apache.hive.druid.org.apache.druid.query.aggregation.last.NumericLastBufferAggregator;
import org.apache.hive.druid.org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.BaseLongColumnValueSelector;

public class DoubleLastBufferAggregator
extends NumericLastBufferAggregator<BaseDoubleColumnValueSelector> {
    public DoubleLastBufferAggregator(BaseLongColumnValueSelector timeSelector, BaseDoubleColumnValueSelector valueSelector) {
        super(timeSelector, valueSelector);
    }

    @Override
    void initValue(ByteBuffer buf, int position) {
        buf.putDouble(position, 0.0);
    }

    @Override
    void putValue(ByteBuffer buf, int position) {
        buf.putDouble(position, ((BaseDoubleColumnValueSelector)this.valueSelector).getDouble());
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        boolean rhsNull = this.isValueNull(buf, position);
        return new SerializablePair<Long, Object>(buf.getLong(position), (rhsNull ? null : Double.valueOf(buf.getDouble(position + 9))));
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return (float)buf.getDouble(position + 9);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return (long)buf.getDouble(position + 9);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return buf.getDouble(position + 9);
    }
}

