/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.cardinality;

import java.util.List;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.hash.HashFunction;
import org.apache.hive.druid.com.google.common.hash.Hasher;
import org.apache.hive.druid.com.google.common.hash.Hashing;
import org.apache.hive.druid.org.apache.druid.hll.HyperLogLogCollector;
import org.apache.hive.druid.org.apache.druid.query.ColumnSelectorPlus;
import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;

public class CardinalityAggregator
implements Aggregator {
    public static final HashFunction HASH_FUNCTION = Hashing.murmur3_128();
    private final ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses;
    private final boolean byRow;
    private HyperLogLogCollector collector;

    static void hashRow(ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses, HyperLogLogCollector collector) {
        Hasher hasher = HASH_FUNCTION.newHasher();
        for (int k = 0; k < selectorPluses.length; ++k) {
            if (k != 0) {
                hasher.putByte((byte)0);
            }
            ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy> selectorPlus = selectorPluses[k];
            selectorPlus.getColumnSelectorStrategy().hashRow(selectorPlus.getSelector(), hasher);
        }
        collector.add(hasher.hash().asBytes());
    }

    static void hashValues(ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses, HyperLogLogCollector collector) {
        for (ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy> selectorPlus : selectorPluses) {
            selectorPlus.getColumnSelectorStrategy().hashValues(selectorPlus.getSelector(), collector);
        }
    }

    @VisibleForTesting
    CardinalityAggregator(List<ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>> selectorPlusList, boolean byRow) {
        this(selectorPlusList.toArray(new ColumnSelectorPlus[0]), byRow);
    }

    CardinalityAggregator(ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>[] selectorPluses, boolean byRow) {
        this.selectorPluses = selectorPluses;
        this.collector = HyperLogLogCollector.makeLatestCollector();
        this.byRow = byRow;
    }

    @Override
    public void aggregate() {
        if (this.byRow) {
            CardinalityAggregator.hashRow(this.selectorPluses, this.collector);
        } else {
            CardinalityAggregator.hashValues(this.selectorPluses, this.collector);
        }
    }

    @Override
    public Object get() {
        return HyperLogLogCollector.makeCollectorSharingStorage(this.collector);
    }

    @Override
    public float getFloat() {
        throw new UnsupportedOperationException("CardinalityAggregator does not support getFloat()");
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException("CardinalityAggregator does not support getLong()");
    }

    @Override
    public double getDouble() {
        throw new UnsupportedOperationException("CardinalityAggregator does not support getDouble()");
    }

    @Override
    public void close() {
    }
}

