/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation.bloom;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.RE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.bloom.BaseBloomFilterAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.bloom.BloomFilterMergeAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.bloom.BloomFilterMergeAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.bloom.DoubleBloomFilterAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.bloom.FloatBloomFilterAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.bloom.LongBloomFilterAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.bloom.NoopBloomFilterAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.bloom.ObjectBloomFilterAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.bloom.StringBloomFilterAggregator;
import org.apache.hive.druid.org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.filter.BloomKFilter;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.NilColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;

public class BloomFilterAggregatorFactory
extends AggregatorFactory {
    private static final int DEFAULT_NUM_ENTRIES = 1500;
    private static final Comparator COMPARATOR = Comparator.nullsFirst((o1, o2) -> {
        if (o1 instanceof ByteBuffer && o2 instanceof ByteBuffer) {
            ByteBuffer buf1 = (ByteBuffer)o1;
            ByteBuffer buf2 = (ByteBuffer)o2;
            return Integer.compare(BloomKFilter.getNumSetBits(buf1, buf1.position()), BloomKFilter.getNumSetBits(buf2, buf2.position()));
        }
        throw new RE("Unable to compare unexpected types [%s]", o1.getClass().getName());
    });
    private final String name;
    private final DimensionSpec field;
    private final int maxNumEntries;

    @JsonCreator
    public BloomFilterAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="field") DimensionSpec field, @JsonProperty(value="maxNumEntries") @Nullable Integer maxNumEntries) {
        this.name = name;
        this.field = field;
        this.maxNumEntries = maxNumEntries != null ? maxNumEntries : 1500;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory columnFactory) {
        return this.factorizeInternal(columnFactory, true);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory columnFactory) {
        return this.factorizeInternal(columnFactory, false);
    }

    @Override
    public Comparator getComparator() {
        return COMPARATOR;
    }

    @Override
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        BloomKFilter.mergeBloomFilterByteBuffers((ByteBuffer)lhs, ((ByteBuffer)lhs).position(), (ByteBuffer)rhs, ((ByteBuffer)rhs).position());
        return lhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        throw new UnsupportedOperationException("Bloom filter aggregators are query-time only");
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new BloomFilterMergeAggregatorFactory(this.name, this.name, (Integer)this.maxNumEntries);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new BloomFilterAggregatorFactory(this.name, this.field, this.maxNumEntries));
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof String) {
            return ByteBuffer.wrap(StringUtils.decodeBase64String((String)object));
        }
        if (object instanceof byte[]) {
            return ByteBuffer.wrap((byte[])object);
        }
        return object;
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public DimensionSpec getField() {
        return this.field;
    }

    @JsonProperty
    public int getMaxNumEntries() {
        return this.maxNumEntries;
    }

    @Override
    public List<String> requiredFields() {
        return Collections.singletonList(this.field.getDimension());
    }

    @Override
    public String getTypeName() {
        return "bloom";
    }

    @Override
    public int getMaxIntermediateSize() {
        return BloomKFilter.computeSizeBytes(this.maxNumEntries);
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(52).appendCacheable(this.field).appendInt(this.maxNumEntries).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BloomFilterAggregatorFactory that = (BloomFilterAggregatorFactory)o;
        return this.maxNumEntries == that.maxNumEntries && Objects.equals(this.name, that.name) && Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.field, this.maxNumEntries);
    }

    public String toString() {
        return "BloomFilterAggregatorFactory{name='" + this.name + '\'' + ", field=" + this.field + ", maxNumEntries=" + this.maxNumEntries + '}';
    }

    private BaseBloomFilterAggregator factorizeInternal(ColumnSelectorFactory columnFactory, boolean onHeap) {
        if (this.field == null || this.field.getDimension() == null) {
            return new NoopBloomFilterAggregator(this.maxNumEntries, onHeap);
        }
        ColumnCapabilities capabilities = columnFactory.getColumnCapabilities(this.field.getDimension());
        if (capabilities != null) {
            ValueType type = capabilities.getType();
            switch (type) {
                case STRING: {
                    return new StringBloomFilterAggregator(columnFactory.makeDimensionSelector(this.field), this.maxNumEntries, onHeap);
                }
                case LONG: {
                    return new LongBloomFilterAggregator(columnFactory.makeColumnValueSelector(this.field.getDimension()), this.maxNumEntries, onHeap);
                }
                case FLOAT: {
                    return new FloatBloomFilterAggregator(columnFactory.makeColumnValueSelector(this.field.getDimension()), this.maxNumEntries, onHeap);
                }
                case DOUBLE: {
                    return new DoubleBloomFilterAggregator(columnFactory.makeColumnValueSelector(this.field.getDimension()), this.maxNumEntries, onHeap);
                }
                case COMPLEX: {
                    return new BloomFilterMergeAggregator(columnFactory.makeColumnValueSelector(this.field.getDimension()), this.maxNumEntries, onHeap);
                }
            }
            throw new IAE("Cannot create bloom filter %s for invalid column type [%s]", new Object[]{onHeap ? "aggregator" : "buffer aggregator", type});
        }
        ColumnValueSelector selector = columnFactory.makeColumnValueSelector(this.field.getDimension());
        if (selector instanceof NilColumnValueSelector) {
            return new NoopBloomFilterAggregator(this.maxNumEntries, onHeap);
        }
        if (selector instanceof DimensionSelector) {
            return new StringBloomFilterAggregator((DimensionSelector)selector, this.maxNumEntries, onHeap);
        }
        return new ObjectBloomFilterAggregator(columnFactory.makeColumnValueSelector(this.field.getDimension()), this.maxNumEntries, onHeap);
    }
}

