/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation;

import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.NullableNumericAggregateCombiner;
import org.apache.hive.druid.org.apache.druid.query.aggregation.NullableNumericAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.NullableNumericBufferAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.NullableNumericVectorAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.hive.druid.org.apache.druid.segment.BaseNullableColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorValueSelector;

public abstract class NullableNumericAggregatorFactory<T extends BaseNullableColumnValueSelector>
extends AggregatorFactory {
    @Override
    public final Aggregator factorize(ColumnSelectorFactory columnSelectorFactory) {
        T selector = this.selector(columnSelectorFactory);
        Aggregator aggregator = this.factorize(columnSelectorFactory, selector);
        return NullHandling.replaceWithDefault() ? aggregator : new NullableNumericAggregator(aggregator, (BaseNullableColumnValueSelector)selector);
    }

    @Override
    public final BufferAggregator factorizeBuffered(ColumnSelectorFactory columnSelectorFactory) {
        T selector = this.selector(columnSelectorFactory);
        BufferAggregator aggregator = this.factorizeBuffered(columnSelectorFactory, selector);
        return NullHandling.replaceWithDefault() ? aggregator : new NullableNumericBufferAggregator(aggregator, (BaseNullableColumnValueSelector)selector);
    }

    @Override
    public final VectorAggregator factorizeVector(VectorColumnSelectorFactory columnSelectorFactory) {
        Preconditions.checkState(this.canVectorize(), "Cannot vectorize");
        VectorValueSelector selector = this.vectorSelector(columnSelectorFactory);
        VectorAggregator aggregator = this.factorizeVector(columnSelectorFactory, selector);
        return NullHandling.replaceWithDefault() ? aggregator : new NullableNumericVectorAggregator(aggregator, selector);
    }

    @Override
    public final AggregateCombiner makeNullableAggregateCombiner() {
        AggregateCombiner combiner = this.makeAggregateCombiner();
        return NullHandling.replaceWithDefault() ? combiner : new NullableNumericAggregateCombiner(combiner);
    }

    @Override
    public final int getMaxIntermediateSizeWithNulls() {
        return this.getMaxIntermediateSize() + (NullHandling.replaceWithDefault() ? 0 : 1);
    }

    protected abstract T selector(ColumnSelectorFactory var1);

    protected VectorValueSelector vectorSelector(VectorColumnSelectorFactory columnSelectorFactory) {
        throw new UnsupportedOperationException("Cannot vectorize");
    }

    protected abstract Aggregator factorize(ColumnSelectorFactory var1, T var2);

    protected abstract BufferAggregator factorizeBuffered(ColumnSelectorFactory var1, T var2);

    protected VectorAggregator factorizeVector(VectorColumnSelectorFactory columnSelectorFactory, VectorValueSelector selector) {
        if (!this.canVectorize()) {
            throw new UnsupportedOperationException("Cannot vectorize");
        }
        throw new UnsupportedOperationException("canVectorize returned true but 'factorizeVector' is not implemented");
    }
}

