/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation;

import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;

public final class NullableNumericAggregateCombiner<T>
implements AggregateCombiner<T> {
    private boolean isNullResult = true;
    private final AggregateCombiner<T> delegate;

    public NullableNumericAggregateCombiner(AggregateCombiner<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void reset(ColumnValueSelector selector) {
        if (selector.isNull()) {
            this.isNullResult = true;
        } else {
            this.isNullResult = false;
            this.delegate.reset(selector);
        }
    }

    @Override
    public void fold(ColumnValueSelector selector) {
        boolean isNotNull;
        boolean bl = isNotNull = !selector.isNull();
        if (isNotNull) {
            if (this.isNullResult) {
                this.isNullResult = false;
                this.delegate.reset(selector);
            } else {
                this.delegate.fold(selector);
            }
        }
    }

    @Override
    public float getFloat() {
        if (this.isNullResult) {
            throw new IllegalStateException("Cannot return primitive float for Null Value");
        }
        return this.delegate.getFloat();
    }

    @Override
    public double getDouble() {
        if (this.isNullResult) {
            throw new IllegalStateException("Cannot return double for Null Value");
        }
        return this.delegate.getDouble();
    }

    @Override
    public long getLong() {
        if (this.isNullResult) {
            throw new IllegalStateException("Cannot return long for Null Value");
        }
        return this.delegate.getLong();
    }

    @Override
    public boolean isNull() {
        return this.isNullResult || this.delegate.isNull();
    }

    @Override
    @Nullable
    public T getObject() {
        return this.isNullResult ? null : (T)this.delegate.getObject();
    }

    @Override
    public Class classOfObject() {
        return this.delegate.classOfObject();
    }
}

