/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation;

import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.segment.BaseLongColumnValueSelector;

public class LongMinAggregator
implements Aggregator {
    private final BaseLongColumnValueSelector selector;
    private long min;

    static long combineValues(Object lhs, Object rhs) {
        return Math.min(((Number)lhs).longValue(), ((Number)rhs).longValue());
    }

    public LongMinAggregator(BaseLongColumnValueSelector selector) {
        this.selector = selector;
        this.min = Long.MAX_VALUE;
    }

    @Override
    public void aggregate() {
        this.min = Math.min(this.min, this.selector.getLong());
    }

    @Override
    public Object get() {
        return this.min;
    }

    @Override
    public float getFloat() {
        return this.min;
    }

    @Override
    public long getLong() {
        return this.min;
    }

    @Override
    public double getDouble() {
        return this.min;
    }

    @Override
    public void close() {
    }
}

