/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query.aggregation;

import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.segment.BaseDoubleColumnValueSelector;

public class DoubleMinAggregator
implements Aggregator {
    private final BaseDoubleColumnValueSelector selector;
    private double min;

    static double combineValues(Object lhs, Object rhs) {
        return Math.min(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
    }

    public DoubleMinAggregator(BaseDoubleColumnValueSelector selector) {
        this.selector = selector;
        this.min = Double.POSITIVE_INFINITY;
    }

    @Override
    public void aggregate() {
        this.min = Math.min(this.min, this.selector.getDouble());
    }

    @Override
    public Object get() {
        return this.min;
    }

    @Override
    public float getFloat() {
        return (float)this.min;
    }

    @Override
    public long getLong() {
        return (long)this.min;
    }

    @Override
    public double getDouble() {
        return this.min;
    }

    @Override
    public void close() {
    }
}

