/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query;

import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.query.ResourceLimitExceededException;

public class QueryInterruptedException
extends RuntimeException {
    public static final String QUERY_INTERRUPTED = "Query interrupted";
    public static final String QUERY_TIMEOUT = "Query timeout";
    public static final String QUERY_CANCELLED = "Query cancelled";
    public static final String RESOURCE_LIMIT_EXCEEDED = "Resource limit exceeded";
    public static final String UNAUTHORIZED = "Unauthorized request.";
    public static final String UNSUPPORTED_OPERATION = "Unsupported operation";
    public static final String UNKNOWN_EXCEPTION = "Unknown exception";
    private final String errorCode;
    private final String errorClass;
    private final String host;

    @JsonCreator
    public QueryInterruptedException(@JsonProperty(value="error") @Nullable String errorCode, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="errorClass") @Nullable String errorClass, @JsonProperty(value="host") @Nullable String host) {
        super(errorMessage);
        this.errorCode = errorCode;
        this.errorClass = errorClass;
        this.host = host;
    }

    public QueryInterruptedException(Throwable cause) {
        this(cause, QueryInterruptedException.getHostFromThrowable(cause));
    }

    public QueryInterruptedException(Throwable cause, String host) {
        super(cause == null ? null : cause.getMessage(), cause);
        this.errorCode = QueryInterruptedException.getErrorCodeFromThrowable(cause);
        this.errorClass = QueryInterruptedException.getErrorClassFromThrowable(cause);
        this.host = host;
    }

    @Nullable
    @JsonProperty(value="error")
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    @JsonProperty(value="errorMessage")
    public String getMessage() {
        return super.getMessage();
    }

    @JsonProperty
    public String getErrorClass() {
        return this.errorClass;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @Override
    public String toString() {
        return StringUtils.format("QueryInterruptedException{msg=%s, code=%s, class=%s, host=%s}", this.getMessage(), this.errorCode, this.errorClass, this.host);
    }

    private static String getErrorCodeFromThrowable(Throwable e) {
        if (e instanceof QueryInterruptedException) {
            return ((QueryInterruptedException)e).getErrorCode();
        }
        if (e instanceof InterruptedException) {
            return QUERY_INTERRUPTED;
        }
        if (e instanceof CancellationException) {
            return QUERY_CANCELLED;
        }
        if (e instanceof TimeoutException) {
            return QUERY_TIMEOUT;
        }
        if (e instanceof ResourceLimitExceededException) {
            return RESOURCE_LIMIT_EXCEEDED;
        }
        if (e instanceof UnsupportedOperationException) {
            return UNSUPPORTED_OPERATION;
        }
        return UNKNOWN_EXCEPTION;
    }

    @Nullable
    private static String getErrorClassFromThrowable(Throwable e) {
        if (e instanceof QueryInterruptedException) {
            return ((QueryInterruptedException)e).getErrorClass();
        }
        if (e != null) {
            return e.getClass().getName();
        }
        return null;
    }

    @Nullable
    private static String getHostFromThrowable(Throwable e) {
        if (e instanceof QueryInterruptedException) {
            return ((QueryInterruptedException)e).getHost();
        }
        return null;
    }

    public static QueryInterruptedException wrapIfNeeded(Throwable e) {
        return e instanceof QueryInterruptedException ? (QueryInterruptedException)e : new QueryInterruptedException(e);
    }
}

