/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.TableDataSource;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.org.apache.druid.query.datasourcemetadata.DataSourceMetadataQuery;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.InDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.hive.druid.org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanQuery;
import org.apache.hive.druid.org.apache.druid.query.search.ContainsSearchQuerySpec;
import org.apache.hive.druid.org.apache.druid.query.search.FragmentSearchQuerySpec;
import org.apache.hive.druid.org.apache.druid.query.search.InsensitiveContainsSearchQuerySpec;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuery;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuerySpec;
import org.apache.hive.druid.org.apache.druid.query.search.SearchSortSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumn;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumns;
import org.joda.time.Interval;

public class Druids {
    public static final Function<String, DimensionSpec> DIMENSION_IDENTITY = new Function<String, DimensionSpec>(){

        @Override
        @Nullable
        public DimensionSpec apply(String input) {
            return new DefaultDimensionSpec(input, input);
        }
    };

    private Druids() {
        throw new AssertionError();
    }

    public static TimeseriesQueryBuilder newTimeseriesQueryBuilder() {
        return new TimeseriesQueryBuilder();
    }

    public static SearchQueryBuilder newSearchQueryBuilder() {
        return new SearchQueryBuilder();
    }

    public static TimeBoundaryQueryBuilder newTimeBoundaryQueryBuilder() {
        return new TimeBoundaryQueryBuilder();
    }

    public static SegmentMetadataQueryBuilder newSegmentMetadataQueryBuilder() {
        return new SegmentMetadataQueryBuilder();
    }

    public static ScanQueryBuilder newScanQueryBuilder() {
        return new ScanQueryBuilder();
    }

    public static DataSourceMetadataQueryBuilder newDataSourceMetadataQueryBuilder() {
        return new DataSourceMetadataQueryBuilder();
    }

    public static class DataSourceMetadataQueryBuilder {
        private DataSource dataSource = null;
        private QuerySegmentSpec querySegmentSpec = null;
        private Map<String, Object> context = null;

        public DataSourceMetadataQuery build() {
            return new DataSourceMetadataQuery(this.dataSource, this.querySegmentSpec, this.context);
        }

        public static DataSourceMetadataQueryBuilder copy(DataSourceMetadataQuery query) {
            return new DataSourceMetadataQueryBuilder().dataSource(query.getDataSource()).intervals(query.getQuerySegmentSpec()).context(query.getContext());
        }

        public DataSourceMetadataQueryBuilder dataSource(String ds) {
            this.dataSource = new TableDataSource(ds);
            return this;
        }

        public DataSourceMetadataQueryBuilder dataSource(DataSource ds) {
            this.dataSource = ds;
            return this;
        }

        public DataSourceMetadataQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public DataSourceMetadataQueryBuilder intervals(String s) {
            this.querySegmentSpec = new LegacySegmentSpec(s);
            return this;
        }

        public DataSourceMetadataQueryBuilder context(Map<String, Object> c) {
            this.context = c;
            return this;
        }
    }

    public static class ScanQueryBuilder {
        private DataSource dataSource = null;
        private QuerySegmentSpec querySegmentSpec = null;
        private VirtualColumns virtualColumns = null;
        private Map<String, Object> context = null;
        private ScanQuery.ResultFormat resultFormat = null;
        private int batchSize = 0;
        private long limit = 0L;
        private DimFilter dimFilter = null;
        private List<String> columns = new ArrayList<String>();
        private Boolean legacy = null;
        private ScanQuery.Order order = null;

        public ScanQuery build() {
            return new ScanQuery(this.dataSource, this.querySegmentSpec, this.virtualColumns, this.resultFormat, this.batchSize, this.limit, this.order, this.dimFilter, this.columns, this.legacy, this.context);
        }

        public static ScanQueryBuilder copy(ScanQuery query) {
            return new ScanQueryBuilder().dataSource(query.getDataSource()).intervals(query.getQuerySegmentSpec()).virtualColumns(query.getVirtualColumns()).resultFormat(query.getResultFormat()).batchSize(query.getBatchSize()).limit(query.getScanRowsLimit()).filters(query.getFilter()).columns(query.getColumns()).legacy(query.isLegacy()).context(query.getContext()).order(query.getOrder());
        }

        public ScanQueryBuilder dataSource(String ds) {
            this.dataSource = new TableDataSource(ds);
            return this;
        }

        public ScanQueryBuilder dataSource(DataSource ds) {
            this.dataSource = ds;
            return this;
        }

        public ScanQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public ScanQueryBuilder virtualColumns(VirtualColumns virtualColumns) {
            this.virtualColumns = virtualColumns;
            return this;
        }

        public ScanQueryBuilder virtualColumns(VirtualColumn ... virtualColumns) {
            return this.virtualColumns(VirtualColumns.create(Arrays.asList(virtualColumns)));
        }

        public ScanQueryBuilder context(Map<String, Object> c) {
            this.context = c;
            return this;
        }

        public ScanQueryBuilder resultFormat(ScanQuery.ResultFormat r) {
            this.resultFormat = r;
            return this;
        }

        public ScanQueryBuilder batchSize(int b) {
            this.batchSize = b;
            return this;
        }

        public ScanQueryBuilder limit(long l) {
            this.limit = l;
            return this;
        }

        public ScanQueryBuilder filters(DimFilter f) {
            this.dimFilter = f;
            return this;
        }

        public ScanQueryBuilder columns(List<String> c) {
            this.columns = c;
            return this;
        }

        public ScanQueryBuilder columns(String ... c) {
            this.columns = Arrays.asList(c);
            return this;
        }

        public ScanQueryBuilder legacy(Boolean legacy) {
            this.legacy = legacy;
            return this;
        }

        public ScanQueryBuilder order(ScanQuery.Order order) {
            this.order = order;
            return this;
        }
    }

    public static class SegmentMetadataQueryBuilder {
        private DataSource dataSource = null;
        private QuerySegmentSpec querySegmentSpec = null;
        private ColumnIncluderator toInclude = null;
        private EnumSet<SegmentMetadataQuery.AnalysisType> analysisTypes = null;
        private Boolean merge = null;
        private Boolean lenientAggregatorMerge = null;
        private Boolean usingDefaultInterval = null;
        private Map<String, Object> context = null;

        public SegmentMetadataQuery build() {
            return new SegmentMetadataQuery(this.dataSource, this.querySegmentSpec, this.toInclude, this.merge, this.context, this.analysisTypes, this.usingDefaultInterval, this.lenientAggregatorMerge);
        }

        public static SegmentMetadataQueryBuilder copy(SegmentMetadataQuery query) {
            return new SegmentMetadataQueryBuilder().dataSource(query.getDataSource()).intervals(query.getQuerySegmentSpec()).toInclude(query.getToInclude()).analysisTypes(query.getAnalysisTypes()).merge(query.isMerge()).lenientAggregatorMerge(query.isLenientAggregatorMerge()).usingDefaultInterval(query.isUsingDefaultInterval()).context(query.getContext());
        }

        public SegmentMetadataQueryBuilder dataSource(String ds) {
            this.dataSource = new TableDataSource(ds);
            return this;
        }

        public SegmentMetadataQueryBuilder dataSource(DataSource ds) {
            this.dataSource = ds;
            return this;
        }

        public SegmentMetadataQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public SegmentMetadataQueryBuilder intervals(String s) {
            this.querySegmentSpec = new LegacySegmentSpec(s);
            return this;
        }

        public SegmentMetadataQueryBuilder intervals(List<Interval> l) {
            this.querySegmentSpec = new LegacySegmentSpec((Object)l);
            return this;
        }

        public SegmentMetadataQueryBuilder toInclude(ColumnIncluderator toInclude) {
            this.toInclude = toInclude;
            return this;
        }

        public SegmentMetadataQueryBuilder analysisTypes(SegmentMetadataQuery.AnalysisType ... analysisTypes) {
            this.analysisTypes = analysisTypes == null ? null : (analysisTypes.length == 0 ? EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class) : EnumSet.copyOf(Arrays.asList(analysisTypes)));
            return this;
        }

        public SegmentMetadataQueryBuilder analysisTypes(EnumSet<SegmentMetadataQuery.AnalysisType> analysisTypes) {
            this.analysisTypes = analysisTypes;
            return this;
        }

        public SegmentMetadataQueryBuilder merge(boolean merge) {
            this.merge = merge;
            return this;
        }

        public SegmentMetadataQueryBuilder lenientAggregatorMerge(boolean lenientAggregatorMerge) {
            this.lenientAggregatorMerge = lenientAggregatorMerge;
            return this;
        }

        public SegmentMetadataQueryBuilder usingDefaultInterval(boolean usingDefaultInterval) {
            this.usingDefaultInterval = usingDefaultInterval;
            return this;
        }

        public SegmentMetadataQueryBuilder context(Map<String, Object> c) {
            this.context = c;
            return this;
        }
    }

    public static class TimeBoundaryQueryBuilder {
        private DataSource dataSource = null;
        private QuerySegmentSpec querySegmentSpec = null;
        private String bound = null;
        private DimFilter dimFilter = null;
        private Map<String, Object> context = null;

        public TimeBoundaryQuery build() {
            return new TimeBoundaryQuery(this.dataSource, this.querySegmentSpec, this.bound, this.dimFilter, this.context);
        }

        public static TimeBoundaryQueryBuilder copy(TimeBoundaryQuery query) {
            return new TimeBoundaryQueryBuilder().dataSource(query.getDataSource()).intervals(query.getQuerySegmentSpec()).bound(query.getBound()).filters(query.getFilter()).context(query.getContext());
        }

        public TimeBoundaryQueryBuilder dataSource(String ds) {
            this.dataSource = new TableDataSource(ds);
            return this;
        }

        public TimeBoundaryQueryBuilder dataSource(DataSource ds) {
            this.dataSource = ds;
            return this;
        }

        public TimeBoundaryQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public TimeBoundaryQueryBuilder intervals(String s) {
            this.querySegmentSpec = new LegacySegmentSpec(s);
            return this;
        }

        public TimeBoundaryQueryBuilder bound(String b) {
            this.bound = b;
            return this;
        }

        public TimeBoundaryQueryBuilder filters(String dimensionName, String value) {
            this.dimFilter = new SelectorDimFilter(dimensionName, value, null);
            return this;
        }

        public TimeBoundaryQueryBuilder filters(DimFilter f) {
            this.dimFilter = f;
            return this;
        }

        public TimeBoundaryQueryBuilder context(Map<String, Object> c) {
            this.context = c;
            return this;
        }
    }

    public static class SearchQueryBuilder {
        private DataSource dataSource = null;
        private DimFilter dimFilter = null;
        private Granularity granularity = Granularities.ALL;
        private int limit = 0;
        private QuerySegmentSpec querySegmentSpec = null;
        private List<DimensionSpec> dimensions = null;
        private SearchQuerySpec querySpec = null;
        private SearchSortSpec sortSpec = null;
        private Map<String, Object> context = null;

        public SearchQuery build() {
            return new SearchQuery(this.dataSource, this.dimFilter, this.granularity, this.limit, this.querySegmentSpec, this.dimensions, this.querySpec, this.sortSpec, this.context);
        }

        public static SearchQueryBuilder copy(SearchQuery query) {
            return new SearchQueryBuilder().dataSource(query.getDataSource()).filters(query.getDimensionsFilter()).granularity(query.getGranularity()).limit(query.getLimit()).intervals(query.getQuerySegmentSpec()).dimensions(query.getDimensions()).query(query.getQuery()).sortSpec(query.getSort()).context(query.getContext());
        }

        public SearchQueryBuilder dataSource(String d) {
            this.dataSource = new TableDataSource(d);
            return this;
        }

        public SearchQueryBuilder dataSource(DataSource d) {
            this.dataSource = d;
            return this;
        }

        public SearchQueryBuilder filters(String dimensionName, String value) {
            this.dimFilter = new SelectorDimFilter(dimensionName, value, null, null);
            return this;
        }

        public SearchQueryBuilder filters(DimFilter f) {
            this.dimFilter = f;
            return this;
        }

        public SearchQueryBuilder granularity(Granularity g) {
            this.granularity = g;
            return this;
        }

        public SearchQueryBuilder limit(int l) {
            this.limit = l;
            return this;
        }

        public SearchQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public SearchQueryBuilder intervals(String s) {
            this.querySegmentSpec = new LegacySegmentSpec(s);
            return this;
        }

        public SearchQueryBuilder intervals(List<Interval> l) {
            this.querySegmentSpec = new LegacySegmentSpec((Object)l);
            return this;
        }

        public SearchQueryBuilder dimensions(String d) {
            this.dimensions = ImmutableList.of(DIMENSION_IDENTITY.apply(d));
            return this;
        }

        public SearchQueryBuilder dimensions(Iterable<String> d) {
            this.dimensions = ImmutableList.copyOf(Iterables.transform(d, DIMENSION_IDENTITY));
            return this;
        }

        public SearchQueryBuilder dimensions(DimensionSpec d) {
            this.dimensions = Collections.singletonList(d);
            return this;
        }

        public SearchQueryBuilder dimensions(List<DimensionSpec> d) {
            this.dimensions = d;
            return this;
        }

        public SearchQueryBuilder query(SearchQuerySpec s) {
            this.querySpec = s;
            return this;
        }

        public SearchQueryBuilder query(String q) {
            Preconditions.checkNotNull(q, "no value");
            this.querySpec = new InsensitiveContainsSearchQuerySpec(q);
            return this;
        }

        public SearchQueryBuilder query(String q, boolean caseSensitive) {
            Preconditions.checkNotNull(q, "no value");
            this.querySpec = new ContainsSearchQuerySpec(q, caseSensitive);
            return this;
        }

        public SearchQueryBuilder fragments(List<String> q) {
            return this.fragments(q, false);
        }

        public SearchQueryBuilder sortSpec(SearchSortSpec sortSpec) {
            this.sortSpec = sortSpec;
            return this;
        }

        public SearchQueryBuilder fragments(List<String> q, boolean caseSensitive) {
            Preconditions.checkNotNull(q, "no value");
            this.querySpec = new FragmentSearchQuerySpec(q, caseSensitive);
            return this;
        }

        public SearchQueryBuilder context(Map<String, Object> c) {
            this.context = c;
            return this;
        }
    }

    public static class TimeseriesQueryBuilder {
        private DataSource dataSource = null;
        private QuerySegmentSpec querySegmentSpec = null;
        private boolean descending = false;
        private VirtualColumns virtualColumns = null;
        private DimFilter dimFilter = null;
        private Granularity granularity = Granularities.ALL;
        private List<AggregatorFactory> aggregatorSpecs = new ArrayList<AggregatorFactory>();
        private List<PostAggregator> postAggregatorSpecs = new ArrayList<PostAggregator>();
        private Map<String, Object> context = null;
        private int limit = 0;

        private TimeseriesQueryBuilder() {
        }

        public TimeseriesQuery build() {
            return new TimeseriesQuery(this.dataSource, this.querySegmentSpec, this.descending, this.virtualColumns, this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.limit, this.context);
        }

        public static TimeseriesQueryBuilder copy(TimeseriesQuery query) {
            return new TimeseriesQueryBuilder().dataSource(query.getDataSource()).intervals(query.getQuerySegmentSpec()).descending(query.isDescending()).virtualColumns(query.getVirtualColumns()).filters(query.getDimensionsFilter()).granularity(query.getGranularity()).aggregators(query.getAggregatorSpecs()).postAggregators(query.getPostAggregatorSpecs()).limit(query.getLimit()).context(query.getContext());
        }

        public TimeseriesQueryBuilder dataSource(String ds) {
            this.dataSource = new TableDataSource(ds);
            return this;
        }

        public TimeseriesQueryBuilder dataSource(DataSource ds) {
            this.dataSource = ds;
            return this;
        }

        public TimeseriesQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public TimeseriesQueryBuilder intervals(String s) {
            this.querySegmentSpec = new LegacySegmentSpec(s);
            return this;
        }

        public TimeseriesQueryBuilder intervals(List<Interval> l) {
            this.querySegmentSpec = new LegacySegmentSpec((Object)l);
            return this;
        }

        public TimeseriesQueryBuilder virtualColumns(VirtualColumns virtualColumns) {
            this.virtualColumns = virtualColumns;
            return this;
        }

        public TimeseriesQueryBuilder virtualColumns(VirtualColumn ... virtualColumns) {
            return this.virtualColumns(VirtualColumns.create(Arrays.asList(virtualColumns)));
        }

        public TimeseriesQueryBuilder filters(String dimensionName, String value) {
            this.dimFilter = new SelectorDimFilter(dimensionName, value, null);
            return this;
        }

        public TimeseriesQueryBuilder filters(String dimensionName, String value, String ... values) {
            this.dimFilter = new InDimFilter(dimensionName, Lists.asList(value, values), null, null);
            return this;
        }

        public TimeseriesQueryBuilder filters(DimFilter f) {
            this.dimFilter = f;
            return this;
        }

        public TimeseriesQueryBuilder descending(boolean d) {
            this.descending = d;
            return this;
        }

        public TimeseriesQueryBuilder granularity(String g) {
            this.granularity = Granularity.fromString(g);
            return this;
        }

        public TimeseriesQueryBuilder granularity(Granularity g) {
            this.granularity = g;
            return this;
        }

        public TimeseriesQueryBuilder aggregators(List<AggregatorFactory> a) {
            this.aggregatorSpecs = a;
            return this;
        }

        public TimeseriesQueryBuilder aggregators(AggregatorFactory ... aggregators) {
            this.aggregatorSpecs = Arrays.asList(aggregators);
            return this;
        }

        public TimeseriesQueryBuilder postAggregators(List<PostAggregator> p) {
            this.postAggregatorSpecs = p;
            return this;
        }

        public TimeseriesQueryBuilder postAggregators(PostAggregator ... postAggregators) {
            this.postAggregatorSpecs = Arrays.asList(postAggregators);
            return this;
        }

        public TimeseriesQueryBuilder context(Map<String, Object> c) {
            this.context = c;
            return this;
        }

        public TimeseriesQueryBuilder limit(int lim) {
            this.limit = lim;
            return this;
        }
    }
}

