/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query;

import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.query.BySegmentResultValueClass;
import org.apache.hive.druid.org.apache.druid.query.QueryContexts;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;

public class BySegmentQueryRunner<T>
implements QueryRunner<T> {
    private final SegmentId segmentId;
    private final DateTime timestamp;
    private final QueryRunner<T> base;

    public BySegmentQueryRunner(SegmentId segmentId, DateTime timestamp, QueryRunner<T> base) {
        this.segmentId = segmentId;
        this.timestamp = timestamp;
        this.base = base;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
        if (QueryContexts.isBySegment(queryPlus.getQuery())) {
            Sequence<T> baseSequence = this.base.run(queryPlus, responseContext);
            List<T> results = baseSequence.toList();
            return Sequences.simple(Collections.singletonList(new Result<BySegmentResultValueClass<T>>(this.timestamp, new BySegmentResultValueClass<T>(results, this.segmentId.toString(), queryPlus.getQuery().getIntervals().get(0)))));
        }
        return this.base.run(queryPlus, responseContext);
    }
}

