/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.metadata;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageActionHandlerTypes;
import org.apache.hive.druid.org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.org.apache.druid.metadata.SQLMetadataStorageActionHandler;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;

public class DerbyMetadataStorageActionHandler<EntryType, StatusType, LogType, LockType>
extends SQLMetadataStorageActionHandler<EntryType, StatusType, LogType, LockType> {
    @VisibleForTesting
    DerbyMetadataStorageActionHandler(SQLMetadataConnector connector, ObjectMapper jsonMapper, MetadataStorageActionHandlerTypes<EntryType, StatusType, LogType, LockType> types, String entryTypeName, String entryTable, String logTable, String lockTable) {
        super(connector, jsonMapper, types, entryTypeName, entryTable, logTable, lockTable);
    }

    @Override
    protected Query<Map<String, Object>> createCompletedTaskInfoQuery(Handle handle, DateTime timestamp, @Nullable Integer maxNumStatuses, @Nullable String dataSource) {
        String sql = StringUtils.format("SELECT   id,   status_payload,   created_date,   datasource,   payload FROM   %s WHERE " + this.getWhereClauseForInactiveStatusesSinceQuery(dataSource) + "ORDER BY created_date DESC", this.getEntryTable());
        if (maxNumStatuses != null) {
            sql = sql + " FETCH FIRST :n ROWS ONLY";
        }
        Query query = (Query)handle.createQuery(sql).bind("start", timestamp.toString());
        if (maxNumStatuses != null) {
            query = (Query)query.bind("n", maxNumStatuses);
        }
        if (dataSource != null) {
            query = (Query)query.bind("ds", dataSource);
        }
        return query;
    }

    private String getWhereClauseForInactiveStatusesSinceQuery(@Nullable String datasource) {
        String sql = StringUtils.format("active = FALSE AND created_date >= :start ", new Object[0]);
        if (datasource != null) {
            sql = sql + " AND datasource = :ds ";
        }
        return sql;
    }

    @Override
    @Deprecated
    public String getSqlRemoveLogsOlderThan() {
        return StringUtils.format("DELETE FROM %s WHERE %s_id in ( SELECT id FROM %s WHERE created_date < :date_time and active = false)", this.getLogTable(), this.getEntryTypeName(), this.getEntryTable());
    }
}

