/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.math.expr;

import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprType;
import org.apache.hive.druid.org.apache.druid.math.expr.UnaryExpr;

class UnaryMinusExpr
extends UnaryExpr {
    UnaryMinusExpr(Expr expr) {
        super(expr);
    }

    @Override
    UnaryExpr copy(Expr expr) {
        return new UnaryMinusExpr(expr);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        ExprEval ret = this.expr.eval(bindings);
        if (NullHandling.sqlCompatible() && ret.value() == null) {
            return ExprEval.of(null);
        }
        if (ret.type() == ExprType.LONG) {
            return ExprEval.of(-ret.asLong());
        }
        if (ret.type() == ExprType.DOUBLE) {
            return ExprEval.of(-ret.asDouble());
        }
        throw new IAE("unsupported type " + (Object)((Object)ret.type()), new Object[0]);
    }

    public String toString() {
        return StringUtils.format("-%s", this.expr);
    }
}

