/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.math.expr;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.IdentifierExpr;

class LambdaExpr
implements Expr {
    private final ImmutableList<IdentifierExpr> args;
    private final Expr expr;

    LambdaExpr(List<IdentifierExpr> args, Expr expr) {
        this.args = ImmutableList.copyOf(args);
        this.expr = expr;
    }

    public String toString() {
        return StringUtils.format("(%s -> %s)", this.args, this.expr);
    }

    int identifierCount() {
        return this.args.size();
    }

    @Nullable
    public String getIdentifier() {
        Preconditions.checkState(this.args.size() < 2, "LambdaExpr has multiple arguments");
        if (this.args.size() == 1) {
            return ((IdentifierExpr)this.args.get(0)).toString();
        }
        return null;
    }

    public List<String> getIdentifiers() {
        return this.args.stream().map(IdentifierExpr::toString).collect(Collectors.toList());
    }

    ImmutableList<IdentifierExpr> getIdentifierExprs() {
        return this.args;
    }

    public Expr getExpr() {
        return this.expr;
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return this.expr.eval(bindings);
    }

    @Override
    public void visit(Expr.Visitor visitor) {
        this.expr.visit(visitor);
        visitor.visit(this);
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        List<IdentifierExpr> newArgs = this.args.stream().map(arg -> (IdentifierExpr)shuttle.visit((Expr)arg)).collect(Collectors.toList());
        Expr newBody = this.expr.visit(shuttle);
        return shuttle.visit(new LambdaExpr(newArgs, newBody));
    }

    @Override
    public Expr.BindingDetails analyzeInputs() {
        Set<String> lambdaArgs = this.args.stream().map(IdentifierExpr::toString).collect(Collectors.toSet());
        Expr.BindingDetails bodyDetails = this.expr.analyzeInputs();
        return bodyDetails.removeLambdaArguments(lambdaArgs);
    }
}

