/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.math.expr;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.Function;

class FunctionExpr
implements Expr {
    final Function function;
    final ImmutableList<Expr> args;
    private final String name;

    FunctionExpr(Function function, String name, List<Expr> args) {
        this.function = function;
        this.name = name;
        this.args = ImmutableList.copyOf(args);
        function.validateArguments(args);
    }

    public String toString() {
        return StringUtils.format("(%s %s)", this.name, this.args);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return this.function.apply(this.args, bindings);
    }

    @Override
    public void visit(Expr.Visitor visitor) {
        for (Expr child : this.args) {
            child.visit(visitor);
        }
        visitor.visit(this);
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        List<Expr> newArgs = this.args.stream().map(shuttle::visit).collect(Collectors.toList());
        return shuttle.visit(new FunctionExpr(this.function, this.name, newArgs));
    }

    @Override
    public Expr.BindingDetails analyzeInputs() {
        Expr.BindingDetails accumulator = new Expr.BindingDetails();
        for (Expr arg : this.args) {
            accumulator = accumulator.with(arg);
        }
        return accumulator.withScalarArguments(this.function.getScalarInputs(this.args)).withArrayArguments(this.function.getArrayInputs(this.args)).withArrayInputs(this.function.hasArrayInputs()).withArrayOutput(this.function.hasArrayOutput());
    }
}

